% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{aphylo-methods}
\alias{aphylo-methods}
\alias{plot.aphylo}
\title{Plot and print methods for \code{aphylo} objects}
\usage{
\method{plot}{aphylo}(
  x,
  y = NULL,
  prop = 0.15,
  node.type.col = c(dupl = "black", other = "gray"),
  node.type.size = c(dupl = 0, other = 0),
  rect.args = list(),
  as_ci = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{aphylo}.}

\item{y}{Ignored.}

\item{prop}{Numeric scalar between 0 and 1. Proportion of the device that the
annotations use in \code{plot.aphylo}.}

\item{node.type.col, node.type.size}{Vectors of length 2. In the case of
\code{node.type.col} the color of the duplication and other nodes. \code{node.type.size}
sets the size of circles.}

\item{rect.args}{List of arguments passed to \link[graphics:rect]{graphics::rect}.}

\item{as_ci}{Integer vector. Internal use only.}

\item{...}{Further arguments passed to \link[ape:plot.phylo]{ape::plot.phylo}.}
}
\value{
In the case of \code{plot.aphylo}, \code{NULL}.
}
\description{
Plot and print methods for \code{aphylo} objects
}
\details{
The \code{plot.aphylo} function is a wrapper of \link[ape:plot.phylo]{ape::plot.phylo}.
}
\examples{
set.seed(7172)
atree <- raphylo(20)
plot(atree)
}
\seealso{
Other aphylo methods: 
\code{\link{aphylo-class}}
}
\concept{aphylo methods}
