% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimic.R
\name{mimic}
\alias{mimic}
\title{Modify a dataset to mimic another dataset}
\usage{
mimic(x, x2, ...)
}
\arguments{
\item{x, x2}{Numeric matrices or data frames.  Each column contains observations
on a different variable.  Missing observations are not allowed.
\code{\link{get_stats}}\code{(x2)} sets the target summary statistics. If \code{x2} is missing
then \code{\link{set_stats}} is called with \code{d = ncol(x)} and any additional arguments
supplied via \code{...}.}

\item{...}{Additional arguments to be passed to \code{\link{set_stats}}.}
}
\value{
A dataset with the same format as \code{x}.  The returned dataset has the
following summary statistics in common with \code{x2}.
\itemize{
\item The sample means of each variable.
\item The sample variances of each variable.
\item The sample correlation matrix.
\item The estimated regression coefficients from least squares linear
regressions of each variable on each other variable.
The target and new summary statistics are returned as attributes
\code{old_stats} and \code{new_stats}.
If \code{x2} is supplied then it is returned as a attribute \code{old_data}.
}
}
\description{
Modifies a dataset \code{x} so that it shares sample summary statistics with
another dataset \code{x2}.  `
}
\details{
The input dataset \code{x} is modified by shifting, scaling and rotating
it so that its sample mean and covariance matrix match those of \code{x2}.
}
\examples{
### 2D examples

# The UK and a dinosaur
got_maps <- requireNamespace("maps", quietly = TRUE)
got_datasauRus <- requireNamespace("datasauRus", quietly = TRUE)
if (got_maps && got_datasauRus) {
  library(maps)
  library(datasauRus)
  dino <- datasaurus_dozen_wide[, c("dino_x", "dino_y")]
  UK <- mapdata("UK")
  new_UK <- mimic(UK, dino)
  plot(new_UK)
}

# Trump and a dinosaur
if (got_datasauRus) {
  library(datasauRus)
  dino <- datasaurus_dozen_wide[, c("dino_x", "dino_y")]
  new_dino <- mimic(dino, trump)
  plot(new_dino)
}

## Examples of passing summary statistics

# The default is zero mean, unit variance and no correlation
new_faithful <- mimic(faithful)
plot(new_faithful)

# Change the correlation
mat <- matrix(c(1, -0.9, -0.9, 1), 2, 2)
new_faithful <- mimic(faithful, correlation = mat)
plot(new_faithful)

### A 3D example

new_randu <- mimic(datasets::randu, datasets::trees)
# The samples summary statistics are equal
get_stats(new_randu)
get_stats(datasets::trees)
}
\seealso{
\code{\link{anscombise}} modifies a dataset so that it shares sample summary
statistics with \link[datasets:anscombe]{Anscombe's quartet}.
}
