% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-waves.R
\name{gen_waves}
\alias{gen_waves}
\title{Generate a wave pattern}
\usage{
gen_waves(x, y = NULL, z = NULL, t = NULL, frequency = 1, ...)
}
\arguments{
\item{x, y, z, t}{The coordinates to get pattern from}

\item{frequency}{The frequency of the generator}

\item{...}{ignored}
}
\value{
A numeric vector
}
\description{
This generator generates multidimensional waves based on \link{cos} to the
distance to the center. This means that you can create ripple waves or
parallel waves depending on how many dimensions you provide. The output is
scaled between -1 and 1 and the frequency determines the number of waves per
unit. The result is much like \code{\link[=gen_spheres]{gen_spheres()}} but has smooth transitions at
each extreme.
}
\examples{
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))
grid$ripple <- gen_waves(grid$x, grid$y)
grid$wave <- gen_waves(grid$x)

plot(grid, ripple)
plot(grid, wave)

}
\seealso{
Other Pattern generators: 
\code{\link{gen_checkerboard}()},
\code{\link{gen_spheres}()}
}
\concept{Pattern generators}
