% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_df.r
\name{gnr_df}
\alias{gnr_df}
\title{Wrapper function to apply gnr_simple across a data.frame or list of species
names}
\usage{
gnr_df(
  df,
  name.column,
  sourceid = NULL,
  best_match = TRUE,
  fuzzy_uninomial = TRUE,
  canonical = TRUE,
  with_context = TRUE,
  higher = FALSE
)
}
\arguments{
\item{df}{data.frame containing names to check}

\item{name.column}{integer or character string with column name containing
species names}

\item{sourceid}{integer vector with data source ids.
see https://resolver.globalnames.org/sources/}

\item{best_match}{boolean. Should the best match be returned based on score?}

\item{fuzzy_uninomial}{boolean. Use fuzzy matching for uninomial names?}

\item{canonical}{If TRUE, names do not include authorship or date}

\item{with_context}{If TRUE, Match scores are weighted for taxonomic
consistency}

\item{higher}{boolean: Return higher taxonomic classifications?}
}
\value{
new data.frame original names (input_name), 1/0 flag for an exact
match,the best match (match_name, and other output from gnr_simple().
			Will contain a row of NAs if no matches were found for a name.
}
\description{
Provides convienent output with a row per name. To streamline merging with
original data.
}
\examples{
data(lakegeneva)
#example dataset with 50 rows

lakegeneva<- genus_species_extract(lakegeneva,'phyto_name')
lakegeneva$genus_species <- trimws(paste(lakegeneva$genus,
lakegeneva$species))

#checking for matches from all GNRS sources, first 5 rows:
lakegeneva.namematches <- gnr_df(lakegeneva,"genus_species")
lakegeneva.namematches
}
