% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_and_config.R
\name{prepare_session}
\alias{prepare_session}
\title{Function for setting up a python environment within R.}
\usage{
prepare_session(env_type = "auto", envname = "aifeducation")
}
\arguments{
\item{env_type}{\code{string} If set to \code{"venv"}  virtual environment is requested. If set to
\code{"conda"} a 'conda' environment is requested. If set to \code{"auto"} the function tries to
activate a virtual environment with the given name. If this environment does not exist
it tries to activate a conda environment with the given name. If this fails
the default virtual environment is used.}

\item{envname}{\code{string} envname name of the requested environment.}
}
\value{
Function does not return anything. It is used for preparing python and R.
}
\description{
This functions checks for python and a specified environment. If the environment exists
it will be activated. If python is already initialized it uses the current environment.
}
\seealso{
Other Installation and Configuration: 
\code{\link{check_aif_py_modules}()},
\code{\link{install_aifeducation}()},
\code{\link{install_aifeducation_studio}()},
\code{\link{install_py_modules}()},
\code{\link{set_transformers_logger}()},
\code{\link{update_aifeducation}()}
}
\concept{Installation and Configuration}
