% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pred.R
\name{get_pred}
\alias{get_pred}
\title{Get Predictions from Stan Model Fit}
\usage{
get_pred(stan_fit)
}
\arguments{
\item{stan_fit}{A \code{stanfit} object returned by \code{get_stanfit}.}
}
\value{
A summary of the predictions and bar charts of each prediction.
}
\description{
Extracts predicted values from a Stan model fit.
}
\examples{
\donttest{
  # Generate toy data
  y_data <- data_simu(n = 60, alpha = 0.5, rho = 0.3, theta = c(5),
                      mod_type = "zi", distri = "poi")

  # Fit a small Stan model (may take > 5s on first compile)
  stan_fit <- get_stanfit(mod_type = "zi", distri = "poi", y = y_data)

  # Get predicted values from the Stan model fit
  get_pred(stan_fit = stan_fit)
}

}
