% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_01_claim_occurrence.R
\name{claim_frequency}
\alias{claim_frequency}
\title{Claim Frequency}
\usage{
claim_frequency(
  I = 40,
  E = 12000,
  freq = 0.03,
  simfun,
  type = c("r", "p"),
  ...
)
}
\arguments{
\item{I}{number of claims development periods considered.}

\item{E}{\strong{effective annual} exposure associated with each period (vector).}

\item{freq}{expected frequency per unit exposure for each period (vector).}

\item{simfun}{optional alternative sampling distribution; see Details.}

\item{type}{the type of \code{simfun} provided. The default is a random generation
function (e.g. \code{rpois}); the alternative \code{"p"} is any valid cumulative
distribution function (e.g. \code{ppois}).}

\item{...}{other arguments/parameters to be passed onto \code{simfun}.}
}
\description{
Returns the number of insurance claims occurring in each of the periods.
}
\details{
Unless otherwise specified, \code{claim_frequency()} assumes the
claim frequency follows a Poisson distribution with mean equal to the
product of exposure \code{E} associated with period \eqn{i} and expected
claim frequency \code{freq} per unit exposure for that period. \cr \cr
If no arguments are provided, by default \code{claim_frequency()} assumes
a total of 40 development periods, constant exposure rate at 12000 per year
and constant frequency at 0.03 per unit of exposure. \cr \cr
If one wishes to use an alternative sampling distribution for claim
frequency, they could declare such specification through the \code{simfun}
argument. The \code{simfun} argument takes both random generation functions
(\code{type = "r"}, the default) and cumulative distribution functions
(\code{type = "p"}). For the latter, \code{claim_frequency()} will first search for the
existence of the corresponding \code{r}-function. If it notes the existence of
such an \code{r}-function (e.g. \code{rpois} for \code{simfun = ppois}), it will directly
apply the \code{r}-function to optimise simulation efficiency. Otherwise, the
function uses a numerical inverse transform method for simulation (see
\code{\link{simulate_cdf}}), which may not be the most efficient and can
potentially result in errors if an appropriate \code{range} is not specified in
the optional arguments. \cr \cr
Pre-defined distribution functions such as \code{ppois} are supported.
}
\examples{
no_period <- 40
exposure <- c(rep(12000, no_period))
exp_freq <- c(rep(0.03, no_period))
# returns the same result as claim_frequency()
claim_frequency(I = no_period, E = exposure, freq = exp_freq)

# use a pre-defined random generation function
claim_frequency(I = 10, simfun = rpois, lambda = 80)
# or equivalently, through a distribution function
claim_frequency(I = 10, simfun = ppois, type = "p", lambda = 80)
}
