% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_stat.R
\name{block_stat}
\alias{block_stat}
\title{Block test statistic}
\usage{
block_stat(x, s, fun = "gmd", varEstim = var)
}
\arguments{
\item{x}{times series or random field to be tested. Either a numeric vector or a numeric matrix.}

\item{s}{parameter for the size of the blocks, 0.5 < s < 1, block length \eqn{l_n = [n^s]}. Default is \code{\link{sOpt}}\code{(n, 0.6)}.}

\item{fun}{Character string; one of "gmd" (default), "var", "jb", "grubbs", "ANOVA".}

\item{varEstim}{variance estimator or variance estimation of the whole field or times series.
Either a function to estimate the variance with, or a numeric value.}
}
\value{
A numeric value.
For \code{fun} = \code{"grubbs"} it has the attribute \code{n}
indicating the number of blocks, i.e. the number of observations used in the Grubbs test.
For \code{fun} = \code{"ANOVA"} it has the attributes \code{k} (number of blocks) and
\code{N} (total number of observations).
}
\description{
Computes test statistics of the block test on structural changes.
}
\details{
First, the time series or random field is divided into blocks and the means of
the blocks are computed. Then the function \code{fun} is applied to the block means:
\itemize{
\item gmd: Gini's mean difference
\item var: Ordinary variance estimator
\item jb: Jarque-Bera test
\item grubbs: Grubbs test for outliers
\item ANOVA: simple ANOVA.
}
}
\examples{
# time series with a shift 
x <- arima.sim(model = list(ar = 0.5), n = 100)
x[1:50] <- x[1:50] + 1
block_stat(x, sOpt(100, 0.6))

# field without shift and ordinary variance
X <- genField(c(50, 50))
block_stat(X, sOpt(50, 0.6), "var")

# field with a shift and ordinary variance
X <- genField(c(50, 50), type = 2)
block_stat(X, sOpt(50, 0.6), "var")

# GMD test statistic, scaling variance estimated by the mad
block_stat(X, 0.6, fun = "var", varEstim = mad)

}
\seealso{
\link{block_pValue}
}
