% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_prediction.R
\name{pred_target_grid}
\alias{pred_target_grid}
\title{Predictive Target Over a Regular Spatial Grid}
\usage{
pred_target_grid(
  object,
  include_covariates = TRUE,
  include_nugget = FALSE,
  include_cov_offset = FALSE,
  include_re = FALSE,
  f_target = NULL,
  pd_summary = NULL
)
}
\arguments{
\item{object}{Output from `pred_over_grid`, a RiskMap.pred.re object.}

\item{include_covariates}{Logical. Include covariates in the predictive target.}

\item{include_nugget}{Logical. Include the nugget effect in the predictive target.}

\item{include_cov_offset}{Logical. Include the covariate offset in the predictive target.}

\item{include_re}{Logical. Include unstructured random effects in the predictive target.}

\item{f_target}{Optional. List of functions to apply on the linear predictor samples.}

\item{pd_summary}{Optional. List of summary functions to apply on the predicted values.}
}
\value{
An object of class 'RiskMap_pred_target_grid' containing predicted values
        and summaries over the regular spatial grid.
}
\description{
Computes predictions over a regular spatial grid using outputs from the
\code{\link{pred_over_grid}} function.
This function allows for incorporating covariates, offsets, and optional
unstructured random effects into the predictive target.
}
\seealso{
\code{\link{pred_over_grid}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
