% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{rduckhts_bam}
\alias{rduckhts_bam}
\title{Create SAM/BAM/CRAM Table}
\usage{
rduckhts_bam(
  con,
  table_name,
  path,
  region = NULL,
  reference = NULL,
  standard_tags = NULL,
  auxiliary_tags = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{con}{A DuckDB connection with DuckHTS loaded}

\item{table_name}{Name for the created table}

\item{path}{Path to the SAM/BAM/CRAM file}

\item{region}{Optional genomic region (e.g., "chr1:1000-2000")}

\item{reference}{Optional reference file path for CRAM files}

\item{standard_tags}{Logical. If TRUE, include typed standard SAMtags columns}

\item{auxiliary_tags}{Logical. If TRUE, include AUXILIARY_TAGS map of non-standard tags}

\item{overwrite}{Logical. If TRUE, overwrites existing table}
}
\value{
Invisible TRUE on success
}
\description{
Creates a DuckDB table from SAM, BAM, or CRAM files using the DuckHTS extension.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
bam_path <- system.file("extdata", "range.bam", package = "Rduckhts")
rduckhts_bam(con, "reads", bam_path, overwrite = TRUE)
dbGetQuery(con, "SELECT COUNT(*) FROM reads WHERE FLAG & 4 = 0")
dbDisconnect(con, shutdown = TRUE)

}
