% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazrate.like.R
\name{hazrate.like}
\alias{hazrate.like}
\title{Hazard rate likelihood}
\usage{
hazrate.like(a, dist, covars, w.hi = NULL)
}
\arguments{
\item{a}{A vector or matrix of covariate 
and expansion term 
coefficients. If matrix, dimension is 
\emph{k} X \emph{p}, where 
\emph{k} = \code{nrow(a)}) is the number of coefficient
vectors to evaluate (cases) and \emph{p} 
= \code{ncol(a)})
is the number of covariate and expansion 
coefficients in the likelihood (i.e., rows are 
cases and columns are covariates). If \code{a} is a 
dimensionless vector, it is interpreted as a 
single row with \emph{k} = 1. 
Covariate coefficients in \code{a} are the first 
\emph{q} values (\emph{q} <= \emph{p}), and must 
be on a log scale.}

\item{dist}{A numeric vector of length \emph{n} or 
a single-column matrix (dimension \emph{n}X1) containing 
detection distances at which to evaluate the likelihood.}

\item{covars}{A numeric vector of length \emph{q} or a
matrix of dimension \emph{n}X\emph{q} containing 
covariate values 
associated with distances in argument \code{dist}.}

\item{w.hi}{A numeric scalar containing maximum 
distance. The right-hand cutoff or upper limit. 
Ignored by some likelihoods (such as halfnorm, 
negexp, and hazrate), but is a fixed parameter
in other likelihoods (such as oneStep 
and uniform).}
}
\value{
A list containing the following two components:
\itemize{
  \item \bold{L.unscaled}: A matrix of size 
   \emph{n}X\emph{k} 
   containing likelihood values evaluated at 
   distances in \code{dist}.
   Each row is associated with 
   a single distance, and each column is associated with 
   a single case (row of \code{a}).  This matrix is  
   "unscaled" because the underlying likelihood does 
   not integrate to one. Values in \code{L.unscaled} 
   are always greater than or equal to zero.
   
 \item \bold{params}: A \emph{n}X\emph{k}X\emph{b} array 
 of the 
 likelihood's (canonical) parameters in link space (i.e., on 
 log scale). First page contains 
 parameter values related to covariates (i.e., 
 \emph{s = exp(x'a)}),
 while subsequent pages contain other parameters. 
 \emph{b} = 1 for halfnorm, negexp; \emph{b} = 2 for 
 hazrate, oneStep, Gamma, and others.
 Rows correspond to distances in \code{dist}. Columns 
 correspond to rows from argument \code{a}. 
}
}
\description{
Computes the hazard rate distance function.
}
\details{
The hazard rate likelihood is 
\deqn{f(x|\sigma,k) = 1 - \exp(-(x/\sigma)^{-k})}{%
f(x|Sigma,k) = 1 - exp(-(x/Sigma)^(-k))} 
where \eqn{\sigma}{Sigma} determines location 
(i.e., distance at which the function equals 1 - exp(-1) = 0.632), 
and \eqn{k}{k} determines slope of the function 
at \eqn{\sigma}{Sigma} (i.e., larger k equals steeper 
slope at \eqn{\sigma}{Sigma}). For distance analysis, 
the valid range for both \eqn{\sigma}{Sigma} and k is
\eqn{\geq 0}{>=0}.
}
\examples{
d <- seq(0, 100, length=100)
covs <- matrix(1,length(d),1)
hazrate.like(c(log(20), 5), d, covs)

# Changing location parameter
plot(d, hazrate.like(c(log(20), 5), d, covs)$L.unscaled, type="l", col="red")
lines(d, hazrate.like(c(log(40), 5), d, covs)$L.unscaled, col="blue")
abline(h = 1 - exp(-1), lty = 2)
abline(v = c(20,40), lty = 2)

# Changing slope parameter
plot(d, hazrate.like(c(log(50), 20), d, covs)$L.unscaled, type="l", col="red")
lines(d, hazrate.like(c(log(50), 2), d, covs)$L.unscaled, col="blue")
abline(h = 1 - exp(-1), lty = 2)
abline(v = 50, lty = 2)

         
}
\seealso{
\code{\link{dfuncEstim}}, 
         \code{\link{abundEstim}},
         other \code{<likelihood>.like} functions
}
