% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{QisInvertible}
\alias{QisInvertible}
\title{Check invertibility}
\usage{
QisInvertible(M)
}
\arguments{
\item{M}{a square matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
A Boolean value indicating whether \code{M} is invertible.
}
\description{
Checks whether a square rational matrix is invertible.
}
\examples{
library(RationalMatrix)
set.seed(666L)
M <- matrix(rpois(25L, 1), 5L, 5L)
QisInvertible(M)
}
