% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_aggregate_samples.R
\name{aggregate_samples}
\alias{aggregate_samples}
\title{Aggregate samples by non-age group}
\usage{
aggregate_samples(
  sample,
  pop,
  margin,
  groups = NULL,
  bind_new = FALSE,
  new_name = NULL
)
}
\arguments{
\item{sample}{an \code{array} of samples imported with \code{load_samples()}}

\item{pop}{The population array to be used for weighted averages.}

\item{margin}{For \code{array}s, The margin on which the groups of interest are stratified.}

\item{groups}{A vector of either indices for each group or a vector of strings for each group name. If set to \code{NULL}, will use all groups in the dataset.}

\item{bind_new}{If set to \code{TRUE}, will bind an \code{array} to the original sample dataset. Otherwise, will generate a standalone array of samples.}

\item{new_name}{The name to assign to the age-standardized group.}
}
\value{
An \code{array} of weighted-average samples.
}
\description{
Consolidates a set of samples over non-age groups using a population array to create weighted-average samples.
}
\details{
\code{aggregate_samples()} is only meant for non-age group data, such as spatial regions, time periods, or other sociodemographic groups (race, sex, etc.). If you are interested in consolidating samples by age group, use \code{age_standardize()} instead. Additionally, if you plan on doing age-standardization along with aggregating by other groups, always aggregate groups first before doing age-standardization to ensure that the samples are properly standardized.
}
\examples{
pop <- miheart$n[1:2, 1:3, 1:3]
time_margin <- 3
# calculate prevalence by aggregating over time periods
samples_3564 <- aggregate_samples(minsample, pop, margin = time_margin)
# calculate prevalence of only the first two time periods
samples_3554 <- aggregate_samples(minsample, pop, time_margin, groups = 1:2)
# bind prevalence samples to original samples
samples_prev <- aggregate_samples(
  minsample,
  pop,
  time_margin,
  bind_new = TRUE,
  new_name = "1979-1981"
)
}
