% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap_data.R
\name{redcap_data}
\alias{redcap_data}
\title{Read REDCap data}
\usage{
redcap_data(
  data_path = NA,
  dic_path = NA,
  event_path = NA,
  uri = NA,
  token = NA,
  filter_field = NA
)
}
\arguments{
\item{data_path}{Character string with the pathname of the R file to read the dataset from.}

\item{dic_path}{Character string with the pathname of the dictionary.}

\item{event_path}{Character string with the pathname of the file containing the correspondence between each event and each form (it can be downloaded through the `Designate Instruments for My Events` tab inside the `Project Setup` section of REDCap)}

\item{uri}{The URI (Uniform Resource Identification) of the REDCap project.}

\item{token}{Character vector with the generated token.}

\item{filter_field}{Character vector with the fields of the REDCap project desired to import into R (API connection only)<.}
}
\value{
List containing the dataset and the dictionary of the REDCap project. If the event_path is specified, it will also contain a third element with the correspondence of the events & forms of the project.
}
\description{
This function allows users to read datasets from a REDCap project into R for analysis, either via export of the data or via an API connection.

The REDCap API is an interface that allows communication with REDCap and server without going through the interactive REDCap interface.
}
\note{
If you will give further use to the package, we advise you to use the argument 'dic_path' to read your dictionary, as all other functions need it in order to run properly.

To read exported data, you must first use REDCap's 'Export Data' function and select the 'R Statistical Software' format. It will then generate a CSV file with all the observations and an R file with the necessary code to complete each variable's information.
}
\examples{
\dontrun{
# Exported files from REDCap

dataset <- redcap_data(data_path = "C:/Users/username/example.r",
                       dic_path = "C:/Users/username/example_dictionary.csv",
                       event_path = "C:/Users/username/events.csv")

# API connection

dataset_api <- redcap_data(uri = "https://redcap.idibell.cat/api/",
                           token = "55E5C3D1E83213ADA2182A4BFDEA") # This token is fictitious

}
}
