% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_data.R
\name{create_time_windows}
\alias{create_time_windows}
\title{Make PupillometryR dataframe into multiple time windows for easy analysis}
\usage{
create_time_windows(data, pupil, breaks)
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil}{column name denoting pupil data to be used}

\item{breaks}{a vector or numbers indicating start times for each window}
}
\value{
a Pupil_window_data dataframe
}
\description{
This function creates a single collapsed data frame for easy analysis with an anova or model,
per condition.
By comparison create_window_data allows collapsing all into a single time window.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
time_window <- create_time_windows(data = base_data, pupil = mean_pupil,
breaks = c(1000, 2000))
}
