% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewShinyPlp.R
\name{viewPlp}
\alias{viewPlp}
\title{viewPlp - Interactively view the performance and model settings}
\usage{
viewPlp(runPlp, validatePlp = NULL, diagnosePlp = NULL)
}
\arguments{
\item{runPlp}{The output of runPlp() (an object of class 'runPlp')}

\item{validatePlp}{The output of externalValidatePlp (on object of class 'validatePlp')}

\item{diagnosePlp}{The output of diagnosePlp()}
}
\value{
Opens a shiny app for interactively viewing the results
}
\description{
This is a shiny app for viewing interactive plots of the performance and the settings
}
\details{
Either the result of runPlp and view the plots
}
\examples{
\dontshow{if (rlang::is_interactive() && rlang::is_installed("OhdsiShinyAppBuilder") ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
saveLoc <- file.path(tempdir(), "viewPlp", "development")
results <- runPlp(plpData, saveDirectory = saveLoc)
# view result files
dir(saveLoc, recursive = TRUE)
# open shiny app
viewPlp(results)
# clean up, shiny app can't be opened after the following has been run
unlink(saveLoc, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
