% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEAXAI_importance_features.R
\name{PEAXAI_global_importance}
\alias{PEAXAI_global_importance}
\title{Global feature importance for efficiency classifiers}
\usage{
PEAXAI_global_importance(
  data,
  x,
  y,
  final_model,
  background = "train",
  target = "train",
  importance_method
)
}
\arguments{
\item{data}{A \code{data.frame} (or \code{matrix}) with predictors and outcomes.
The function will internally reorder columns to \code{c(x, y)}.}

\item{x}{Integer or character vector with the columns used as \strong{inputs} (predictors).}

\item{y}{Integer or character vector with the columns used as \strong{outputs} (targets used
to define \code{class_efficiency} in training; not included in \code{X} when explaining).}

\item{final_model}{A fitted model. If it is a base-\code{glm} binomial, probabilities
are obtained with \code{type = "response"}; otherwise the function expects
\code{predict(type = "prob")} with a column named \code{"efficient"}.}

\item{background}{Character, \code{"train"} (default) or \code{"real"}.
Background data define the distribution used for the reference model behaviour.}

\item{target}{Character, \code{"train"} (default) or \code{"real"}.
Dataset on which importance is computed.}

\item{importance_method}{A named list (or data.frame-like) with the backend and its args:
\describe{
\item{\code{name}}{One of \code{"SA"}, \code{"SHAP"}, \code{"PI"}.}
\item{\code{method}}{(SA) One of \code{"1D-SA"}, \code{"sens"}, \code{"DSA"}, \code{"MSA"}, \code{"CSA"}, \code{"GSA"}.}
\item{\code{measures}}{(SA) e.g. \code{"AAD"}, \code{"gradient"}, \code{"variance"}, \code{"range"}.}
\item{\code{levels}}{(SA) Discretization levels used by \code{rminer::Importance}.}
\item{\code{baseline}}{(SA) Baseline value for SA, if applicable.}
\item{\code{nsim}}{(SHAP) Number of Monte Carlo samples for \code{fastshap::explain}.}
\item{\code{n.repetitions}}{(PI) Number of permutations per feature for \code{iml::FeatureImp}.}
}}
}
\value{
A named numeric vector (or 1-row data.frame) of normalized importances,
with names matching the predictor columns; the values sum to 1.
}
\description{
Computes \strong{global feature importance} for a fitted classification model that
separates Pareto-efficient DMUs, using one of three XAI backends:
\itemize{
\item \code{"SA"} — Sensitivity Analysis via \pkg{rminer}.
\item \code{"SHAP"} — Model-agnostic SHAP approximations via \pkg{fastshap}.
\item \code{"PI"} — Permutation Importance via \pkg{iml}.
}
You can evaluate the model on either the training domain (\code{background = "train"})
or the real-world domain (\code{background = "real"}) and compute importance on a
chosen \code{target} set (\code{"train"} or \code{"real"}). Importances are
returned normalized to sum to 1.
}
\details{
Internally, the function builds background/target sets with \code{xai_prepare_sets()}.
For \code{glm} models, the positive class is assumed to be the \strong{second level}
(\code{"efficient"}) and probabilities are extracted with \code{type = "response"}.
For other models (e.g., \pkg{caret}), \code{predict(type = "prob")[, "efficient"]} is used.
}
\examples{
\donttest{
  data("firms", package = "PEAXAI")

  data <- subset(
    firms,
    autonomous_community == "Comunidad Valenciana"
  )

  x <- 1:4
  y <- 5
  RTS <- "vrs"
  imbalance_rate <- NULL

  trControl <- list(
    method = "cv",
    number = 3
  )

  # glm method
  methods <- list(
    "glm" = list(
      weights = "dinamic"
     )
   )

  metric_priority <- c("Balanced_Accuracy", "ROC_AUC")

  models <- PEAXAI_fitting(
    data = data, x = x, y = y, RTS = RTS,
    imbalance_rate = imbalance_rate,
    methods = methods,
    trControl = trControl,
    metric_priority = metric_priority,
    seed = 1,
    verbose = FALSE
  )

  final_model <- models[["best_model_fit"]][["glm"]]

  imp <- PEAXAI_global_importance(
    data = data, x = x, y = y,
    final_model = final_model,
    background = "real", target = "real",
    importance_method = list(name = "PI", n.repetitions = 5)
  )

  head(imp)
}

}
\seealso{
\code{\link[fastshap]{explain}}, \code{\link[iml]{FeatureImp}},
\code{\link[rminer]{Importance}}
}
