% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erddapToEdinfo.R
\name{erddapToEdinfo}
\alias{erddapToEdinfo}
\alias{hycomToEdinfo}
\title{Create an edinfo Object from an ERDDAP Dataset Id}
\usage{
erddapToEdinfo(
  dataset,
  baseurl = c("https://upwell.pfeg.noaa.gov/erddap/",
    "https://coastwatch.pfeg.noaa.gov/erddap/", "https://www.ncei.noaa.gov/erddap/",
    "https://erddap.sensors.ioos.us/erddap"),
  chooseVars = TRUE
)

hycomToEdinfo(
  dataset = "GLBy0.08/expt_93.0",
  baseurl = "https://ncss.hycom.org/thredds/ncss/",
  chooseVars = TRUE
)
}
\arguments{
\item{dataset}{an ERDDAP or HYCOM dataset id, or the result from \link[rerddap]{info}}

\item{baseurl}{the base URL of an ERDDAP/HYCOM server}

\item{chooseVars}{logical flag whether or not to select which variables you want now
or character vector naming variables to select}
}
\value{
an edinfo list object that can be used to download environmental data
}
\description{
Creates an edinfo object that can be used to create a URL for
  downloading environmental data using \link{edinfoToURL}
}
\examples{
\dontrun{
# examples not run because they require internet connection
sstEdi <- erddapToEdinfo('jplMURSST41')
# dataset from a diferent erddap server
sshEdi <- erddapToEdinfo('hawaii_soest_2ee3_0bfa_a8d6',
                          baseurl = 'http://apdrc.soest.hawaii.edu/erddap/')
# THese work the same - erddap function will pass to hycom if appears to be hycom dataset
hycomEdi <- hycomToEdinfo('GLBy0.08/expt_93.0')
hycomEdi <- erddapToEdinfo('GLBy0.08/expt_93.0')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
