% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addPlots}
\alias{addPlots}
\title{Add custom plotting functions}
\usage{
addPlots(study, plots, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{plots}{A nested list containing custom plotting functions and plot
metadata. The input object is a 3-level nested list. The first, or
top-level list element name(s) must match the study \code{modelID}(s). The second,
or mid-level list element name(s) must match the names of the plotting
function(s) defined in the current R session (see Details below for
function construction requirements). The third, or bottom-level list
provides metadata to categorize, display, and support each plot. The
accepted fields are \code{displayName}, \code{description}, \code{plotType}, \code{models}, and
\code{packages.} \code{displayName} sets the plot name in the app and the \code{description}
field will display as a tool tip when hovering over plotting dropdown
menus. The \code{plotType} field is a character vector that categorizes the plot
by 1) the number of features it supports (“\code{singleFeature}” or
“\code{multiFeature}”), 2) the number of test results used by the plotting
function (“\code{singleTest}”, “\code{multiTest}”), 3) if data from one or more models is
used (add “\code{multiModel}” to specify that data from two or more models are
used in the plot; otherwise the plot is assumed to reference only data
within the model specified by the top-level list element name), and 4) if
the plot is interactive (add “\code{plotly}” to specify interactive plots built
using the plotly package; otherwise the plot is assumed to be static).
e.g., \code{plotType = c("multiFeature", "multiTest", "plotly")}. If you do not
specify the \code{plotType}, the plot will be designated as \code{plotType = c("singleFeature", "singleTest")}. The \code{models} field is an optional
character vector that specifies the models that should be used by the app
when invoking your custom plotting function. This field is set to ‘all’ by
default and is only used when \code{plotType} includes “\code{multiModel}”. If this field
is not included the app will assume all models in the study should be used
with your plotting function. If the plotting function requires additional
packages beyond those attached by default to a fresh R session, these must
be defined in the element \code{packages}. To share a plotting functions across
multiple models, use the modelID "default". Alternatively, to share a plot
across a specific subset of models, you can explicitly add the same
plotting function to each model (option available as of OmicNavigator
1.16.0).}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
\code{study}, but modified to include the newly added data
}
\description{
\code{addPlots()} adds custom plotting functions and plot metadata to an
OmicNavigator study.
}
\details{
Custom plotting functions must be constructed to accept as the first argument
the value returned from \code{getPlottingData()}. Custom plotting functions can
have additional arguments, but these must be provided with default values.
The end-user should call \code{getPlottingData()} when testing their custom
plotting function.  The end-user should consider the nature of the plot, i.e.
the \code{plotType} and (rarely) \code{models} values (see \code{\link[=getPlottingData]{getPlottingData()}}). For
example, a custom plotting function meant to produce a \code{multiTest} plot
should accept the output of a \code{getPlottingData()} call with multiple
\code{testID}s assigned to the \code{testID} argument. See the details section of
\code{\link[=plotStudy]{plotStudy()}} for a description of how \code{plotType} dictates the way a custom
plotting function is invoked by the app.

Note that any ggplot2 plots will require extra care. This is because the
plotting code will be inserted into a study package, and thus must follow the
\href{https://ggplot2.tidyverse.org/articles/ggplot2-in-packages.html#using-aes-and-vars-in-a-package-function-1}{best
practices for using ggplot2 within packages}. Specifically, when you refer to
columns of the data frame, e.g. \code{aes(x = group)}, you need to prefix it
with \code{.data$}, so that it becomes \code{aes(x = .data$group)}.
Fortunately this latter code will also run fine as you interactively develop
the function.

Note that the plotting functions are written to the R package when the study
is exported via \code{\link{exportStudy}} or installed via
\code{\link{installStudy}}, not when \code{addPlots} is invoked. In other
words, if you add a custom plotting function to your study object via
\code{addPlots}, but then subsequently update the function in the global
environment prior to installing the study, this latest version will be saved
in the R package and executed when run in the app.
}
\seealso{
\code{\link{getPlottingData}}, \code{\link{plotStudy}}
}
