% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{octo900.presentKinetic}
\alias{octo900.presentKinetic}
\title{Present Kinetic stimuli on O900 (internal use)}
\arguments{
\item{stim}{Stimulus to present (a list, see details).}

\item{nextStim}{Ignored.}
}
\value{
A list containing
\itemize{
\item \code{err}  String message or NULL for no error.
\item \code{seen} 1 if seen, 0 otherwise.
\item \code{time} Reaction time (if seen).
\item \code{x} Coordinate where button was pressed (degrees - i guess).
\item \code{y} Coordinate where button was pressed (degrees - i guess).
}
}
\description{
Implementation of opiPresent for Kinetic stimuli on the Octopus090 machine.

This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with
these Arguments and \code{stim} as class \code{opiKineticStimulus}
and you will get the Value back.
}
\details{
\code{stim} is a list containing at least the following 3 elements:
\itemize{
\item \code{path}, A list of $(x,y)$ coordinates in degrees that is usable by \code{xy.coords()}.
\item \code{sizes}, A list where \code{sizes[i]} is the size of stimulus (diameter in degrees)
to use for the section of path specified by \code{path[i]..path[i+1]}.
Rounded to nearest Goldmann size.
\item \code{levels} A list where \code{levels[i]} is the stimulus luminance in cd/\eqn{\mbox{m}^2}{m^2}
to use for the section of path specified by \code{path[i]..path[i+1]}.
\item \code{speeds} A list where \code{speeds[i]} is the speed in degrees per second
to use for the section of path specified by \code{path[i]..path[i+1]}.
}
}
