% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_data_arm.R
\name{convert_data_arm}
\alias{convert_data_arm}
\title{Convert contrast-based dataset to arm-based dataset}
\usage{
convert_data_arm(nt, nc, pt, pc)
}
\arguments{
\item{nt}{Number of subjects in treatment arm}

\item{nc}{Number of subjects in control arm}

\item{pt}{Number of events in treatment arm}

\item{pc}{Number of events in treatment arm}
}
\value{
A dataframe object
}
\description{
\code{convert_data_arm} creates a dataframe to fit a Binomial-Normal
Hierarchical model using \code{glmer} function.
}
\examples{
data('dat.Crins2014', package = "MetaStan")
## Subset of dataset where PTLD outcomes available
dat.Crins2014.PTLD = subset(dat.Crins2014, is.finite(exp.PTLD.events))
## Create arm-based dataset
dat.Crins2014.PTLD.arm <- convert_data_arm(dat.Crins2014.PTLD$exp.total,
dat.Crins2014.PTLD$cont.total,dat.Crins2014.PTLD$exp.PTLD.events,
dat.Crins2014.PTLD$cont.PTLD.events)


}
