% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{histamine_matrix}
\alias{histamine_matrix}
\title{Histamine in Dogs}
\format{
A numeric matrix with 16 rows and 4 columns:
\describe{
  \item{Before}{Blood histamine levels measured before drug administration}
  \item{After1}{Histamine levels measured after 1 minute}
  \item{After3}{Histamine levels measured after 3 minutes}
  \item{After5}{Histamine levels measured after 5 minutes}
}
}
\source{
Data taken from the msos package version 1.2.0
}
\usage{
data(histamine_matrix)
}
\description{
This dataset, histamine_matrix, is a matrix containing data on blood histamine
levels in dogs after drug treatment. Sixteen dogs were used to assess morphine
and trimethaphan effects on blood histamine concentration. Dogs were divided into
four groups: two received morphine, two received trimethaphan (both intravenous).
In each drug pair, one group had histamine depleted prior to treatment, the other
retained normal levels. Values of "0.10" indicate originally missing data,
arbitrarily imputed with that value.
}
\details{
The dataset name has been kept as 'histamine_matrix' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'matrix' indicates that the dataset is stored as a matrix object. The original content has not been modified
in any way.
}
