% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MadDateRanges.R
\name{MadDateRanges}
\alias{MadDateRanges}
\title{Convert a vector of date ranges into a data.frame}
\usage{
MadDateRanges(dateRanges)
}
\arguments{
\item{dateRanges}{character vector of date ranges, each associated with a
different source.}
}
\value{
a \code{data.frame} with 3 columns
\describe{
\item{yearBegin, yearEnd}{numeric years}
\item{sourceNum}{1, 2, 3, ... for the location in \code{dateRanges}}
}
}
\description{
\code{MadDateRanges} returns a \code{\link{data.frame}} with 3 numeric columns:
\code{yearBegin}, \code{yearEnd}, and \code{sourceNum} from the vector of \code{dateRanges}
associated with different sources in \code{\link{MaddisonSources}}.
}
\examples{
MadDateRanges(c('1', '700 – 1500', '1252–1700 (England)', 
      '1915-1919 & 1949', '1820, 1870, 1913, 1950'))
# equal 
data.frame(
yearBegin=c(1,  700, 1252, 1820, 1870, 1913, 1950), 
yearEnd  =c(1, 1500, 1700, 1820, 1870, 1913, 1950), 
sourceNum=c(1, 2, 3, rep(4, 4)))

}
\keyword{manip}
