% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ViolinPlot.R
\name{plot_ViolinPlot}
\alias{plot_ViolinPlot}
\title{Create a violin plot}
\usage{
plot_ViolinPlot(
  data,
  boxplot = TRUE,
  rug = TRUE,
  summary = c("n", "median"),
  summary.pos = "sub",
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{\link{numeric} or \linkS4class{RLum.Results} (\strong{required}):
input data for plotting. Alternatively a \link{data.frame} or a \link{matrix} can
be provided, but only the first column will be considered by the
function}

\item{boxplot}{\link{logical} (\emph{with default}):
enable/disable boxplot}

\item{rug}{\link{logical} (\emph{with default}):
enable/disable rug}

\item{summary}{\link{character} (\emph{with default}):
add statistic measures of centrality and dispersion to the plot.
Can be one or more of several keywords. See details for available keywords.}

\item{summary.pos}{\link{numeric} or \link{character} (\emph{with default}):
optional position keywords (cf. \link{legend}) for the statistical summary.
Alternatively, the keyword \code{"sub"} may be specified to place the summary
below the plot header. However, this latter option in only possible if
\code{mtext} is not used.}

\item{na.rm}{\link{logical} (\emph{with default}):
exclude NA values from the data set prior to any further operations.}

\item{...}{further arguments and graphical parameters passed to
\link{plot.default}, \link[stats:density]{stats::density} and \link{boxplot}. See details for further
information.}
}
\description{
Draws a kernel density plot in combination with a boxplot in its middle.
The shape of the violin is constructed using a mirrored density curve.
This plot is especially designed for cases where the individual errors are
zero or too small to be visualised. The idea for this plot is based on the
'violin plot' in the \code{ggplot2} package by Hadley Wickham and Winston Chang.
The general idea for the violin plot seems to have been introduced by
Hintze and Nelson (1998).
}
\details{
The function is passing several arguments to the functions \link{plot},
\link[stats:density]{stats::density}, \link[graphics:boxplot]{graphics::boxplot}:

Supported arguments are:
\code{xlim}, \code{main}, \code{xlab}, \code{ylab}, \code{col.violin}, \code{col.boxplot}, \code{mtext}, \code{cex}, \code{mtext}

\strong{\verb{Valid summary keywords}}

\code{'n'}, \code{'mean'}, \code{'median'}, \code{'sd.abs'}, \code{'sd.rel'}, \code{'se.abs'}, \code{'se.rel'}.
\code{'skewness'}, \code{'kurtosis'}
}
\note{
Although the code for this function was developed independently and just
the idea for the plot was based on the 'ggplot2' plot type 'violin', it
should be mentioned that, beyond this, at least another R package produces
this kind of plot, namely \code{'vioplot'} (see references for details).
}
\section{Function version}{
 0.1.4
}

\examples{

## read example data set
data(ExampleData.DeValues, envir = environment())
ExampleData.DeValues <- convert_Second2Gray(ExampleData.DeValues$BT998,
                                            c(0.0438,0.0019))

## create plot straightforward
plot_ViolinPlot(data = ExampleData.DeValues)

} 

\section{How to cite}{
Kreutzer, S., 2025. plot_ViolinPlot(): Create a violin plot. Function version 0.1.4. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.1. https://r-lum.github.io/Luminescence/
}

\references{
Daniel Adler (2025). vioplot: violin plot.
R package version 0.5.1 http://CRAN.R-project.org/package=vioplot

Hintze, J.L., Nelson, R.D. (1998). A Box Plot-Density Trace Synergism.
The American Statistician 52, 181-184.

Wickham. H (2009). ggplot2: elegant graphics for data analysis. Springer New York.
}
\seealso{
\link[stats:density]{stats::density}, \link{plot}, \link{boxplot}, \link{rug}, \link{calc_Statistics}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
