% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.all.data.R
\name{load.all.data}
\alias{load.all.data}
\title{Attemps to load and merge all timeseries data for a given site name}
\usage{
load.all.data(lake.name, data.path, checkMerge=TRUE)
}
\arguments{
\item{lake.name}{The file prefix to be matched. For example, \dQuote{sparkling} matches \dQuote{sparkling.wtr} but not \dQuote{troutbog.wtr}}

\item{data.path}{The directory to look for files}

\item{checkMerge}{Should check merge size before attempting to prevent potential merge problems.}
}
\value{
A list with two items
 \item{data}{}
 \item{metadata}{}
}
\description{
Loads and returns all the data available in the specified directory for a given site.
All timeseries data are merged by \dQuote{datetime} into a single \link{data.frame}.
Data are identified by the column header information.
}
\seealso{
\link{load.ts}
\link{load.meta}
}
\author{
Luke A. Winslow
}
\keyword{IO}
\keyword{file}
