% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_tests.R
\name{negative_binomial_p_one_sample}
\alias{negative_binomial_p_one_sample}
\title{Test the p parameter of a negative binomial distribution.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
negative_binomial_p_one_sample(
  num_failures,
  num_successes,
  p,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{num_failures}{Number of failures.}

\item{num_successes}{Number of successes.}

\item{p}{Hypothesized probability of success.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the p parameter of a negative binomial distribution.
}
\examples{
library(LRTesteR)

# Null is true. 48 failures before 52 successes.
negative_binomial_p_one_sample(48, 52, .50, "two.sided")

# Null is false. 25 failures before 75 successes.
negative_binomial_p_one_sample(25, 75, .50, "two.sided")
}
