% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_mode.R
\name{llm_parse_structured_col}
\alias{llm_parse_structured_col}
\title{Parse structured fields from a column into typed vectors}
\usage{
llm_parse_structured_col(
  .data,
  fields,
  structured_col = "response_text",
  prefix = "",
  allow_list = TRUE
)
}
\arguments{
\item{.data}{data.frame/tibble}

\item{fields}{Character vector of fields or named vector (dest_name = path).}

\item{structured_col}{Column name to parse from. Default "response_text".}

\item{prefix}{Optional prefix for new columns.}

\item{allow_list}{Logical. If TRUE (default), non-scalar values (arrays/objects)
are hoisted as list-columns instead of being dropped. If FALSE, only scalar
fields are hoisted and non-scalars become NA.}
}
\value{
\code{.data} with diagnostics and one new column per requested field.
}
\description{
Extracts fields from a column containing structured JSON (string or list) and
appends them as new columns. Adds \code{structured_ok} (logical) and \code{structured_data} (list).
}
\details{
\itemize{
\item Supports nested-path extraction via dot/bracket paths (e.g., \code{a.b[0].c})
or JSON Pointer (\code{/a/b/0/c}).
\item When \code{allow_list = TRUE}, non-scalar values become list-columns; otherwise
they yield \code{NA} and only scalars are hoisted.
}
}
