% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy.irtree_fit}
\alias{tidy.irtree_fit}
\title{Tidy an irtree_fit object}
\usage{
\method{tidy}{irtree_fit}(x = NULL, par_type = NULL, ...)
}
\arguments{
\item{x}{object of class irtree_fit as returned from  \code{\link[=fit.irtree_model]{fit()}}.}

\item{par_type}{Only used if the fit engine was mirt. Item parameters (or
thresholds) can be either of type \code{easiness} (the mirt default) or
\code{difficulty} (as in Mplus and TAM).}

\item{...}{Not currently used.}
}
\value{
A \link[tibble:tibble-package]{tibble} with one row for each model
parameter and the following columns:
\describe{
\item{\code{term}}{The name of the model parameter.}
\item{\code{estimate}}{The estimated value of the term.}
\item{\code{std.error}}{The standard error of the term.}
\item{\code{statistic}}{The value of the test statistic of the term (Mplus only).}
\item{\code{p.value}}{The p-value associated with the statistic (Mplus only).}
}
}
\description{
Tidy summarizes information about the parameter estimates of an ItemResponseTrees model.
}
\examples{
data("jackson")
df1 <- jackson[1:234, paste0("C", 1:5)]
irtree_create_template(df1)
m1 <- "
IRT:
t BY C1@1, C2@1, C3@1, C4@1, C5@1;
Class:
GRM"
fit1 <- fit(irtree_model(m1), data = df1)

tidy(fit1, par_type = "difficulty")

glance(fit1)

augment(fit1)
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}}
}
