% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew-normal.R
\name{dsnorm}
\alias{dsnorm}
\title{The Skew Normal Distribution}
\usage{
dsnorm(x, xi, omega, alpha, logC = 0, log = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{xi}{Location parameter.}

\item{omega}{Scale parameter.}

\item{alpha}{Shape parameter.}

\item{logC}{Log-normalization constant.}

\item{log}{Logical; if TRUE, returns the log density.}
}
\value{
A numeric vector of (log) density values.
}
\description{
Density for the skew normal distribution with location \code{xi}, scale \code{omega},
and shape \code{alpha}.
}
\examples{
x <- seq(-2, 5, length.out = 100)
y <- dsnorm(x, xi = 0, omega = 1, alpha = 5)
plot(x, y, type = "l", main = "Skew Normal Density")
}
\references{
https://en.wikipedia.org/wiki/Skew_normal_distribution
}
