% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_inhalation_rate.R
\name{simulate_inhalation_rate}
\alias{simulate_inhalation_rate}
\title{Simulate inhalation rates}
\usage{
simulate_inhalation_rate(x, IR_params = NULL)
}
\arguments{
\item{x}{atomic vector or list of atomic vectors containing ages.}

\item{IR_params}{(optional) data frame with columns "age", "mean" and "sd".
See details for more information.}
}
\value{
List of atomic vectors containing inhalation rates.
}
\description{
Simulate inhalation rates
}
\details{
The age column of the optional \code{IR_params} data frame should be in ascending
order and represent the lower value of age groups for the corresponding mean
and sd values. When not provided, the default values will come from Table 6.7
of EPA's 2011 Exposure Factors Handbook using the mean of male and female
values.
}
\examples{
# Single atomic vector
ages <- sample(1:100, 6, replace = TRUE)
simulate_inhalation_rate(ages)

# List of atomic vectors
ages <- list(
  sample(1:100, 5, replace = TRUE),
  sample(1:100, 3, replace = TRUE)
)
simulate_inhalation_rate(ages)

# Custom IR_params
IR_params <- data.frame("age" = c(0, 20, 50),
                        "mean" = c(0.5, 0.3, 0.2),
                        "sd" = c(0.1, 0.06, 0.03))
simulate_inhalation_rate(c(15, 30, 65), IR_params)

}
