#' @title Run multiple simplifyGOFromMultipleLists
#'
#' @description
#' This function runs the simplifyGOFromMultipleLists function with
#' different combinations of semantic similarity measures and clustering methods.
#'
#' @param all_selection_GO A list of dataframes. The GO object for the simplifyGOFromMultipleLists function.
#' @param padj_column Character. The column name for the p-value adjustment.
#' @param padj_cutoff Numeric. The cutoff for the p-value adjustment.
#' @param ont Character. The ontology for the simplifyGOFromMultipleLists function.
#'
#' @return A named list containing heatmaps for each combination of semantic similarity measure and clustering method.
#'         Each list element is named by combining the measure and method names (e.g., "Wang_kmeans"),
#'         and contains the heatmap object generated by the `simplifyGOFromMultipleLists` function.
#'
run_multiple_simplifyGO <- function(all_selection_GO, padj_column, padj_cutoff, ont) {

  if (!requireNamespace("simplifyEnrichment", quietly = TRUE)) {
    stop("The simplifyEnrichment package is required but not installed. Please install it first.")
  }


  # Define the measure and method values internally
  measure_values <- c("Wang", "Resnik", "Rel", "Jiang", "Lin")
  method_values <- c("kmeans", "pam", "dynamicTreeCut", "mclust", "apcluster", "hdbscan",
                     "louvain", "walktrap", "MCL", "binary_cut")

  # Initialize a list to store the results
  results <- list()

  # Loop over each measure and method
  for (measure in measure_values) {
    for (method in method_values) {

      # Print the current method and measure
      print(paste("Running with measure =", measure, "and method =", method))

      # Run simplifyGOFromMultipleLists with the current measure and method
      hmap <- simplifyEnrichment::simplifyGOFromMultipleLists(all_selection_GO, padj_column=padj_column,
                                          padj_cutoff=padj_cutoff, ont=ont, measure=measure, method=method)

      # Add the heatmap to the results list
      results[[paste(measure, method, sep="_")]] <- hmap
    }
  }

  return(results)
}
