% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cmsc}
\alias{cmsc}
\alias{cmsc_e1}
\alias{cmsc_e2}
\alias{gcsm}
\title{Composite similarity between vectors}
\usage{
cmsc(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

cmsc_e1(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

cmsc_e2(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

gcsm(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)
}
\arguments{
\item{x}{A vector.}

\item{y}{The other vector.}

\item{rescale}{Rescale or not before computation.}

\item{xmin, xmax, ymin, ymax}{Normalization parameters. If \code{NA}, are calculated
from the ranges of \code{x} and \code{y}, respectively. See Details.}

\item{comp}{Variable to return. If \code{"si"}, the composite measure, if
\code{"s1"},\code{"s2"} or \code{"s3"}, the corresponding component.}
}
\value{
A number.
}
\description{
Compute composite measures, GCSM or CMSC, between two vectors.
}
\details{
These functions compute composite measures between vectors. Missing values
are omitted. Normalization parameters are used to rescale \code{x} and \code{y}, and
determine the global minimum (min) and maximum (max). If \code{rescale} is
\code{TRUE}, \code{x} and \code{y} are rescaled to \code{(x-xmin)/(xmax-xmin)} and
\code{(y-ymin)/(ymax-ymin)}; and set \code{min=0}, \code{max=1}. If \code{FALSE},
\code{min=min(xmin,ymin)}, \code{max=max(xmax,ymax)}.
}
\examples{
x = runif(9)
gcsm(x, x)
cmsc(x, x)
# mean shift
gcsm(x, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
cmsc(x, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
gcsm(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
cmsc(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
## dissimilarity
y = 1 - x # y is the perfect antianalog of x
gcsm(y, x)
gcsm(y, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
gcsm(y, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)

# random noise
noise = rnorm(9, mean = 0, sd = 0.2)
gcsm(x, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
cmsc(x, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
## dissimilarity
gcsm(y, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
}
