% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_long_surv.R
\name{monitor_long_surv}
\alias{monitor_long_surv}
\title{Monitor Longitudinal Data for Survival Outcomes}
\usage{
monitor_long_surv(
  data_array_new,
  time_matrix_new,
  nobs_new,
  pattern,
  method,
  parameter = 0.5,
  CL = Inf
)
}
\arguments{
\item{data_array_new}{observed data arranged in a numeric array format. \cr
\code{data_array_new[i,j,k]} is the jth observation of the kth dimension of the ith subject.}

\item{time_matrix_new}{observation times arranged in a numeric matrix format. \cr
\code{time_matrix_new[i,j]} is the jth observation time of the ith subject. \cr
\code{data_array_new[i,j,]} is observed at \code{time_matrix[i,j]}.}

\item{nobs_new}{number of observations arranged as an integer vector. \cr
\code{nobs_new[i]} is the number of observations for the ith subject.}

\item{pattern}{the estimated longitudinal and survival pattern from \code{estimate_pattern_long_surv}.}

\item{method}{a character value specifying the smoothing method\cr
If \code{method="risk"}, apply the risk monitoring method by You and Qiu (2020).}

\item{parameter}{a numeric value. \cr
The weighting parameter in the modified EWMA charts.}

\item{CL}{a numeric value specifying the control limit}
}
\value{
a list that stores the result.\cr
\item{$chart}{charting statistics arranged in a matrix.}
\item{$standardized_values}{standardized values arranged in a matrix.}
}
\description{
Monitor Longitudinal Data for Survival Outcomes
}
\examples{
data("data_example_long_surv")

result_pattern<-estimate_pattern_long_surv(
  data_array=data_example_long_surv$data_array_IC,
  time_matrix=data_example_long_surv$time_matrix_IC,
  nobs=data_example_long_surv$nobs_IC,
  starttime=data_example_long_surv$starttime_IC,
  survtime=data_example_long_surv$survtime_IC,
  survevent=data_example_long_surv$survevent_IC,
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  estimation_method="risk",
  smoothing_method="local linear",
  bw_beta=0.05,
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_surv(
  data_array_new=data_example_long_surv$data_array_OC,
  time_matrix_new=data_example_long_surv$time_matrix_OC,
  nobs_new=data_example_long_surv$nobs_OC,
  pattern=result_pattern,
  method="risk",
  parameter=0.5)
}
\references{
You, L. and Qiu, P. (2020). An effective method for online disease risk monitoring. Technometrics, 62(2):249-264.
}
