% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pattern_long_md.R
\name{estimate_pattern_long_md}
\alias{estimate_pattern_long_md}
\title{Estimate the Regular Longitudinal Pattern of Multivariate Data}
\usage{
estimate_pattern_long_md(
  data_array,
  time_matrix,
  nobs,
  design_interval,
  n_time_units,
  time_unit,
  estimation_method,
  bw_mean,
  bw_var,
  bw_cov
)
}
\arguments{
\item{data_array}{observed data arranged in a 3d array format. \cr
\code{data_array[i,j,k]} is the jth observation of the kth dimension of the ith subject.}

\item{time_matrix}{observation times arranged in a numeric matrix format. \cr
\code{time_matrix[i,j]} is the jth observation time of the ith subject. \cr
\code{data_array[i,j,]} is observed at \code{time_matrix[i,j]}.}

\item{nobs}{number of observations arranged as an integer vector. \cr
\code{nobs[i]} is the number of observations for the ith subject.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{estimation_method}{a string. \cr
If \code{estimation_method="meanvar"}, the function will estimate the 
mean function (\eqn{\mathrm{E}[\mathbf{y}(t)]}), and 
variance function (\eqn{\mathrm{Var}(\mathbf{y}(t))}). 
Parameters \code{bw_mean_int} and \code{bw_var_int} are needed. \cr
If \code{estimation_method="meanvarcov"}, the function will estimate the 
mean function (\eqn{\mathrm{E}[\mathbf{y}(t)]}), 
variance function (\eqn{\mathrm{Var}(\mathbf{y}(t))}), and 
covariance function (\eqn{\mathrm{Cov}(\mathbf{y}(s),\mathbf{y}(t))}). 
Parameters \code{bw_mean_int}, \code{bw_var_int} and \code{bw_cov_int}.}

\item{bw_mean}{a numeric value. \cr
The bandwidth parameter for estimating mean function.}

\item{bw_var}{a numeric value. \cr
The bandwidth parameter for estimating variance function.}

\item{bw_cov}{a numeric value. \cr
The bandwidth parameter for estimating covariance function.}
}
\value{
an object that stores the estimated longitudinal pattern and model parameters. \cr
If \code{estimation_method="meanvar"}, returns an object of class \code{pattern_long_md_meanvar}. \cr
If \code{estimation_method="meanvarcov"}, returns an object of class \code{pattern_long_md_meanvarcov}. \cr
\item{$grid}{Discretized design interval.}
\item{$mean_est}{Estimated mean function.}
\item{$var_est}{Estimated variance function.}
\item{$cov_est}{Estimated covariance function.}
}
\description{
Function \code{estimate_pattern_long_md} estimate the regular longitudinal pattern 
of multivariate processes from a dataset of n subjects. This is usually the first step of dynamic screening.
The pattern can be described by mean, variance, covariance, and distribution depending on the estimation method. 
When the estimated pattern is used for monitoring new subjects, the collected data from new subjects are 
compared to the estimated pattern for monitoring abnormality.
}
\details{
Estimate the Regular Longitudinal Pattern of Multivariate Data
}
\examples{
data("data_example_long_md")

result_pattern<-estimate_pattern_long_md(
  data_array=data_example_long_md$data_array_IC,
  time_matrix=data_example_long_md$time_matrix_IC,
  nobs=data_example_long_md$nobs_IC,
  design_interval=data_example_long_md$design_interval,
  n_time_units=data_example_long_md$n_time_units,
  estimation_method="meanvar",
  bw_mean=0.1,
  bw_var=0.1)
}
\references{
Qiu, P. and Xiang, D. (2015). Surveillance of cardiovascular diseases using a multivariate dynamic screening system. Statistics in Medicine, 34:2204-2221. \cr
Li, J. and Qiu, P. (2017). Construction of an efficient multivariate dynamic screening system. Quality and Reliability Engineering International, 33(8):1969-1981. \cr
You, L., Qiu, A., Huang, B., and Qiu, P. (2020). Early detection of severe juvenile idiopathic arthritis by sequential monitoring of patients' health-related quality of life scores. Biometrical Journal, 62(5).
}
