% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datassim.R
\name{datassim}
\alias{datassim}
\title{Data Assimilation}
\usage{
datassim(X, Var, Corr)
}
\arguments{
\item{X}{Matrix of predictions, with \code{n} number of rows as the number of observations, and \code{t} number of columns as the number of time points from which data were collected.}
%
\item{Var}{Matrix of corresponding prediction variances, same dimension as \code{X}.}
%
\item{Corr}{Matrix or value of correlations between observations from different time points, by default \code{Corr} = 0.}
}
\value{
\item{$weights}{Estimated Kalman gain according to Eq.[7] in Ehlers \emph{et al.} (2017).}
%
\item{$PreDA}{Predicted values through Data Assimilation according to Eq.[5] in Ehlers \emph{et al.} (2017).}
%
\item{$VarDA}{Corresponding estimated variances according to Eq.[6] in Ehlers \emph{et al.} (2017).}
%
\item{$Correlation}{Correlation matrix.}
}
\description{
This function estimates a variable of interest through Data Assimilation technique by incorporating results from previous assessments.
}
\examples{
Pred1 = rnorm(10, mean = 50, sd = 100);
Pred2 = rnorm(10, mean = 50, sd = 30);
Pred3 = rnorm(10, mean = 50, sd = 80);
Pred4 = rnorm(10, mean = 50, sd = 100);
%
# Predictions based on ten observations, at four different time points
Prediction = cbind(Pred1, Pred2, Pred3, Pred4); 
%
Var1 = matrix(10000, 10);
Var2 = matrix(900, 10);
Var3 = matrix(1600, 10);
Var4 = matrix(10000, 10);
%
# Corresponding prediction variances
Variance = cbind(Var1, Var2, Var3, Var4);
%
# Corr = 0 by default
datassim(X = Prediction, Var = Variance);
%
# Corr = 0.5
datassim(Prediction, Variance, 0.5); 
%
Corr = cor(Prediction);
datassim(Prediction, Variance, Corr);
%
}
\references{
Ehlers, S., Saarela, S., Lindgren, N., Lindberg, E., Nyström, M., Grafström, A., Persson, H., Olsson, H. & Ståhl, G. (2017). Assessing error correlations in remote sensing-based predictions of forest attributes for improved data assimilation. \href{https://doi.org/10.20944/preprints201710.0098.v1}{DOI}
}

