% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_M.R
\name{tps.rbf}
\alias{tps.rbf}
\title{TPS radial basis function}
\usage{
tps.rbf(x, is.even)
}
\arguments{
\item{x}{is a Euclidean distance between two points.}

\item{is.even}{is a logical argument indicating TRUE if the dimension of the space where the thin-plate spline smoother is being fitted is even.}
}
\value{
The resulting value of the thin-plate spline radial basis function.
}
\description{
Function to compute the thin-plate splines radial basis function for internal use by the function make.M().
}
\details{
This function computes the thin-plate spline radial basis function depending on the if d is odd or even.
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y
X <- scale(coordinates(meuse.all))
D <- as.matrix(dist(X))
K <- tps.rbf(D, TRUE)
}
