% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{add_reflectance}
\alias{add_reflectance}
\title{Add Reflectance column to LAS if it is missing for RIEGL vz400i}
\usage{
add_reflectance(las)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing an individually
segmented tree containing an `Intensity` column representing 16-bit range-
corrected amplitude from RIEGL vz400i Terrestrial Lidar Scanner}
}
\value{
modified LAS object with Reflectance column
}
\description{
Function to provide relative Reflectance for RIEGL vz400i. Lidar prediction
of crown scorch is based on relative range-corrected
reflectance relative to a white reference object orthonormal to
scanner. Raw range-corrected amplitudes from RIEGL vz400i are linearly
correlated to relative intensity which usually ranges from -20 dB to 0 dB
}
\examples{
library(lidR)
library(CrownScorchTLS)

 #download external data from github repo
url <- paste0(
  "https://raw.githubusercontent.com/jbcannon/CrownScorchTLS-data/main/data/manual-clip-trees/",
  "M-04-15549_post.laz")
 las_file = tempfile(fileext = paste0(".", tools::file_ext(url)))
 download.file(url, las_file, mode = "wb", quiet = TRUE)
 las <- readLAS(las_file)

 # or load your own data
 #las <- readLAS('C:/path/to/your/file.laz')

las = add_reflectance(las)
colnames(las@data)
}
