% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{CoxRunMulti}
\alias{CoxRunMulti}
\title{Fully runs a cox or fine-gray regression model with multiple column realizations, returning the model and results}
\usage{
CoxRunMulti(
  model,
  df,
  a_n = list(c(0)),
  keep_constant = c(0),
  realization_columns = matrix(c("temp00", "temp01", "temp10", "temp11"), nrow = 2),
  realization_index = c("temp0", "temp1"),
  control = list(),
  gradient_control = list(),
  single = FALSE,
  observed_info = FALSE,
  fma = FALSE,
  mcml = FALSE,
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0),
  ...
)
}
\arguments{
\item{model}{either a formula written for the get_form function, or the model result from the get_form function.}

\item{df}{a data.table containing the columns of interest}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{keep_constant}{binary values to denote which parameters to change}

\item{realization_columns}{used for multi-realization regressions. Matrix of column names with rows for each column with realizations, columns for each realization}

\item{realization_index}{used for multi-realization regressions. Vector of column names, one for each column with realizations. Each name should be used in the "names" variable in the equation definition}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{gradient_control}{a list of control options for the gradient descent algorithm. If any value is given, a gradient descent algorithm is used instead of Newton-Raphson. See the Control_Options vignette for details}

\item{single}{a boolean to denote that only the log-likelihood should be calculated and returned, no derivatives or iterations}

\item{observed_info}{a boolean to denote that the observed information matrix should be used to calculate the standard error for parameters, not the expected information matrix}

\item{fma}{a boolean to denote that the Frequentist Model Averaging method should be used}

\item{mcml}{a boolean to denote that the Monte Carlo Maximum Likelihood method should be used}

\item{cons_mat}{Matrix containing coefficients for a system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for a system of linear constraints, formatted as vector}

\item{...}{can include the named entries for the control list parameter}
}
\value{
returns a class fully describing the model and the regression results
}
\description{
\code{CoxRunMulti} uses a formula, data.table, and list of controls to prepare and
run a Colossus cox or fine-gray regression function
}
\examples{
library(data.table)
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "t0" = c(18, 20, 18, 19, 21, 20, 18),
  "t1" = c(30, 45, 57, 47, 36, 60, 55),
  "lung" = c(0, 0, 1, 0, 1, 0, 0),
  "dose" = c(0, 1, 1, 0, 1, 0, 1)
)
set.seed(3742)
df$rand <- floor(runif(nrow(df), min = 0, max = 5))
df$rand0 <- floor(runif(nrow(df), min = 0, max = 5))
df$rand1 <- floor(runif(nrow(df), min = 0, max = 5))
df$rand2 <- floor(runif(nrow(df), min = 0, max = 5))
names <- c("dose", "rand")
realization_columns <- matrix(c("rand0", "rand1", "rand2"), nrow = 1)
realization_index <- c("rand")
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiter" = 1,
  "halfmax" = 2, "epsilon" = 1e-6,
  "deriv_epsilon" = 1e-6, "step_max" = 1.0,
  "thres_step_max" = 100.0,
  "verbose" = 0, "ties" = "breslow", "double_step" = 1
)
formula <- Cox(t0, t1, lung) ~ loglinear(dose, rand, 0) + multiplicative()
res <- CoxRun(formula, df, control = control)
}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{CoxRun}()},
\code{\link{LikelihoodBound.coxres}()},
\code{\link{RunCoxRegression_Omnibus}()}
}
\concept{Cox Wrapper Functions}
