% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyByConcept.R
\name{stratifyByConcept}
\alias{stratifyByConcept}
\title{Stratify a codelist by the concepts included within it.}
\usage{
stratifyByConcept(x, cdm, keepOriginal = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference via CDMConnector.}

\item{keepOriginal}{Whether to keep the original codelist and append the
stratify (if TRUE) or just return the stratified codelist (if FALSE).}
}
\value{
The codelist or a codelist with details with the required
stratifications, as different elements of the list.
}
\description{
Stratify a codelist by the concepts included within it.
}
\examples{
\donttest{
library(CodelistGenerator)
cdm <- mockVocabRef()
codes <- list("concepts" = c(20,21))
new_codes <- stratifyByConcept(x = codes,
                               cdm = cdm,
                               keepOriginal = TRUE)
new_codes
}
}
