% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_Observation.R
\name{modify_Observation}
\alias{modify_Observation}
\title{Modify Observation class in PML models}
\usage{
modify_Observation(
  PMLParametersSets,
  ObservationName,
  SigmasChosen,
  BQL,
  BQLValue,
  Frozen,
  ResetObs,
  Covariates,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{ObservationName}{A character string giving the name of the Observation.}

\item{SigmasChosen}{a \link{Sigmas} class instance or a list specifying the
chosen sigma values for different error models. 0s are treated as no
values. Inside Observation class it is transormed and kept as \link{Sigmas}
class. The list could contain the following error models:
\itemize{
\item Additive The additive error sigma value.
\item LogAdditive The log-additive error sigma value.
\item Proportional The proportional error sigma value.
\item AdditiveMultiplicative A numeric vector specifying the additive and multiplicative parts
for the additive-multiplicative error model. The vector should have names
\code{PropPart} and \code{AddPart}.
\item MixRatio A numeric vector specifying the proportional and additive parts for the mix-ratio
error model. The vector should have names \code{PropPart} and \code{AddPart}.
\item Power A numeric vector specifying the standard deviation and power parts for the power error model.
The vector should have names \code{StdevPart} and \code{PowerPart}.
}}

\item{BQL}{A logical value indicating whether the dataset contains BQL values
and they should be taken into account (M3 method).}

\item{BQLValue}{An optional numeric positive value of static LLOQ. Applicable
only when BQL argument is \code{TRUE}. Any observed value less than or equal to
that LLOQ value is treated as censored.}

\item{Frozen}{A logical value indicating if the standard deviation (Stdev) is
frozen.}

\item{ResetObs}{A logical value indicating if the Observation variable should
be reset to 0 after observation (\code{doafter={A0=0;}}). Applicable for
elimination compartment.}

\item{Covariates}{A list of covariates (\code{Covariate} instances) that should be
included in the model, but not linked to any of structural parameters.
Used with "Emax" PD models ('C' covariate is added automatically when
creating a new model, but should be added manually when modifying the model).}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the observation will be modified. For the naming
convention of PMLStructures, see Details section of
\code{\link[=create_ModelPK]{create_ModelPK()}} for PK models and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Modify Observation class in PML models
}
\details{
This function can only be used to modify the structural parameters
in the built-in models (i.e., created using either \code{create_ModelEmax()} or
\code{create_ModelPK()}).
}
\examples{
PMLParametersSets <-
  create_ModelPK(CompartmentsNumber = c(1, 2, 3))
# update structural paramter type
PMLParametersSetsVMod <-
 modify_Observation(
   PMLParametersSets,
   ObservationName = "CObs",
   SigmasChosen = Sigmas(Proportional = 0,
                         AdditiveMultiplicative =
                           list(PropPart = 0.1, AddPart = 10)))

print(PMLParametersSetsVMod)

}
\seealso{
\code{\link[=list_Observations]{list_Observations()}}

Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{ObservationCustom}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{remove_Observation}()}
}
\concept{Observations}
