% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_number_of_clusters_stable_process.R
\name{log_Vnk_PY}
\alias{log_Vnk_PY}
\title{Calculate the Logarithm of the Vnk weights for the Pitman-Yor model}
\usage{
log_Vnk_PY(n, k, Alpha, Gama)
}
\arguments{
\item{n}{An integer representing the total number of observations.}

\item{k}{An integer representing the number of clusters.}

\item{Alpha}{A numeric value for the concentration parameter.}

\item{Gama}{A numeric value for the discount parameter.}
}
\value{
A numeric value representing the logarithm of the NRMI for the specified parameters.
}
\description{
This function computes the logarithm of the Vnk weights for the Pitman-Yor model
for given values of `n`, `k`, `Alpha`, and `Gama`.
}
\examples{
BNPdensity:::log_Vnk_PY(7, 6, 0.5, 0.01)
BNPdensity:::log_Vnk_PY(6, 5, 0.5, 0.001)
}
