% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGedcom.R
\name{applyTagMappings}
\alias{applyTagMappings}
\title{Apply Tag Mappings to a Line}
\usage{
applyTagMappings(line, record, pattern_rows, tag_mappings)
}
\arguments{
\item{line}{A character string from the GEDCOM file.}

\item{record}{A named list representing the individual's record.}

\item{pattern_rows}{A list with GEDCOM tag counts.}

\item{tag_mappings}{A list of lists. Each sublist should define:
- \code{tag}: the GEDCOM tag,
- \code{field}: the record field to update,
- \code{mode}: either "replace" or "append",
- \code{extractor}: (optional) a custom extraction function.}
}
\value{
A list with the updated record (\code{record}) and a logical flag (\code{matched}).
}
\description{
Iterates over a list of tag mappings and, if a tag matches the line, updates the record.
}
