% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaR.R
\name{VaR}
\alias{VaR}
\title{Calculating Value-at-Risk (VaR)}
\usage{
VaR(x, p = 0.99, portfolio_weights = NULL, distribution = "empirical")
}
\arguments{
\item{x}{An object of class "bekkFit" from the function \link{bekk_fit} or an object of class "bekkForecast" from the function \link{predict}.}

\item{p}{A numerical value that determines the confidence level. The default value is set at 0.99 in accordance with the Basel Regulation.}

\item{portfolio_weights}{A vector determining the portfolio weights to calculate the portfolio VaR. If set to "NULL", the univariate VaR for each series are calculated.}

\item{distribution}{A character string determining the assumed distribution of the residuals. Implemented are "normal", "empirical" and "t". The default is using the empirical distribution of the residuals.}
}
\value{
Returns a S3 class "var" object containing the VaR forecast and respective confidence bands.
}
\description{
Method for calculating VaR from estimated covariance processes (\link{bekk_fit}) or predicted covariances (\link{predict}).
}
\examples{
\donttest{

data(StocksBonds)
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

# single VaRs of series
x2 <- VaR(x1, distribution="normal")
plot(x2)

# VaR of equally-weighted portfolio
portfolio_weights <- c(0.5, 0.5)
x3 <- VaR(x1, portfolio_weights = portfolio_weights)
plot(x3)

# VaR of traditional 30/70 weighted bond and stock portfolio
portfolio_weights <- c(0.3, 0.7)
x4 <- VaR(x1, portfolio_weights = portfolio_weights)
plot(x4)

}

}
