% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{VIF}
\alias{VIF}
\title{Get Maximum Variance Inflation Factor (VIF) from a Model}
\usage{
VIF(model)
}
\arguments{
\item{model}{A regression model, such as those created by lm, glm, or other similar functions.}
}
\value{
The maximum VIF value.
}
\description{
This function calculates the maximum Variance Inflation Factor (VIF) for a given model.
The VIF is a measure of collinearity among predictor variables within a regression model.
It quantifies how much the variance of an estimated regression coefficient is increased due to collinearity.
A VIF of 1 indicates no collinearity, while values above 1 indicate increasing levels of collinearity.
A VIF of 5 or greater is often considered high, indicating a strong presence of collinearity.
}
\references{
\itemize{
\item Belsley, D. A., Kuh, E., & Welsch, R. E. (1980). Regression Diagnostics: Identifying Influential Data and Sources of Collinearity. John Wiley & Sons.
\item Kutner, M. H., Nachtsheim, C. J., Neter, J., & Li, W. (2004). Applied Linear Statistical Models. McGraw-Hill/Irwin.
\item O'Brien, R. M. (2007). A caution regarding rules of thumb for variance inflation factors. Quality & Quantity, 41(5), 673-690.
}
}
\keyword{collinearity}
