/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.sa.base.core.diagnostics.CombinedSeasonalityOptions;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityTests;
import jdplus.sa.base.core.diagnostics.ResidualSeasonalityTests;
import jdplus.sa.base.core.diagnostics.ResidualSeasonalityTestsOptions;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysTests;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysTestsOptions;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.diagnostics.RegArimaDiagnostics;
import jdplus.toolkit.base.core.regarima.tests.OneStepAheadForecastingTest;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class GenericSaTests
implements GenericExplorable {
    private final RegSarimaModel regarima;
    private final boolean mul;
    private final TsData linearized;
    private final TsData residuals;
    private final TsData y;
    private final TsData sa;
    private final TsData irr;
    private final TsData si;
    private final TsData lsa;
    private final TsData lirr;
    private volatile ResidualSeasonalityTests linearizedTests;
    private volatile ResidualSeasonalityTests residualsTests;
    private volatile ResidualSeasonalityTests lsaTests;
    private volatile ResidualSeasonalityTests lirrTests;
    private volatile CombinedSeasonalityTests combinedTests;
    private volatile ResidualTradingDaysTests tdTests;
    private volatile OneStepAheadForecastingTest outOfSampleTest;

    private GenericSaTests(RegSarimaModel regarima, boolean mul, TsData y, TsData res, TsData sa, TsData irr, TsData si, TsData lin, TsData lsa, TsData lirr) {
        this.regarima = regarima;
        this.mul = mul;
        this.linearized = lin;
        this.residuals = res;
        this.y = y;
        this.sa = sa;
        this.irr = irr;
        this.si = si;
        this.lsa = lsa;
        this.lirr = lirr;
    }

    public int annualFrequency() {
        return this.linearized.getAnnualFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResidualSeasonalityTests residualSeasonalityTestsOnResiduals() {
        if (this.residuals == null) {
            return null;
        }
        ResidualSeasonalityTests tests = this.residualsTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.residualsTests;
                if (tests == null) {
                    this.residualsTests = tests = ResidualSeasonalityTests.builder().series(this.residuals).ndiff(0).mean(false).options(ResidualSeasonalityTestsOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResidualSeasonalityTests seasonalityTestsOnLinearized() {
        if (this.linearized == null) {
            return null;
        }
        ResidualSeasonalityTests tests = this.linearizedTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.linearizedTests;
                if (tests == null) {
                    this.linearizedTests = tests = ResidualSeasonalityTests.builder().series(this.linearized).ndiff(-1).mean(true).options(ResidualSeasonalityTestsOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResidualSeasonalityTests residualSeasonalityTestsOnSa() {
        if (this.lsa == null) {
            return null;
        }
        ResidualSeasonalityTests tests = this.lsaTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.lsaTests;
                if (tests == null) {
                    this.lsaTests = tests = ResidualSeasonalityTests.builder().series(this.lsa).ndiff(-1).mean(true).options(ResidualSeasonalityTestsOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResidualSeasonalityTests residualSeasonalityTestsOnIrregular() {
        if (this.lirr == null) {
            return null;
        }
        ResidualSeasonalityTests tests = this.lirrTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.lirrTests;
                if (tests == null) {
                    this.lirrTests = tests = ResidualSeasonalityTests.builder().series(this.lirr).ndiff(0).mean(false).options(ResidualSeasonalityTestsOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonalityTests combinedSeasonalityTests() {
        CombinedSeasonalityTests tests = this.combinedTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.combinedTests;
                if (tests == null) {
                    this.combinedTests = tests = CombinedSeasonalityTests.builder().y(this.y).sa(this.sa).si(this.si).irr(this.irr).mul(this.mul).residuals(this.residuals).options(CombinedSeasonalityOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResidualTradingDaysTests residualTradingDaysTests() {
        ResidualTradingDaysTests tests = this.tdTests;
        if (tests == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                tests = this.tdTests;
                if (tests == null) {
                    this.tdTests = tests = ResidualTradingDaysTests.builder().sa(this.lsa).irr(this.lirr).residuals(this.residuals).options(ResidualTradingDaysTestsOptions.getDefault()).build();
                }
            }
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneStepAheadForecastingTest forecastingTest() {
        if (this.regarima == null) {
            return null;
        }
        OneStepAheadForecastingTest os = this.outOfSampleTest;
        if (os == null) {
            GenericSaTests genericSaTests = this;
            synchronized (genericSaTests) {
                os = this.outOfSampleTest;
                if (os == null) {
                    try {
                        this.outOfSampleTest = os = RegArimaDiagnostics.oneStepAheadForecastingTest((RegArimaModel)this.regarima.regarima(), (double)0.0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return os;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public RegSarimaModel getRegarima() {
        return this.regarima;
    }

    @Generated
    public boolean isMul() {
        return this.mul;
    }

    @Generated
    public TsData getLinearized() {
        return this.linearized;
    }

    @Generated
    public TsData getResiduals() {
        return this.residuals;
    }

    @Generated
    public TsData getY() {
        return this.y;
    }

    @Generated
    public TsData getSa() {
        return this.sa;
    }

    @Generated
    public TsData getIrr() {
        return this.irr;
    }

    @Generated
    public TsData getSi() {
        return this.si;
    }

    @Generated
    public TsData getLsa() {
        return this.lsa;
    }

    @Generated
    public TsData getLirr() {
        return this.lirr;
    }

    @Generated
    private ResidualSeasonalityTests getLinearizedTests() {
        return this.linearizedTests;
    }

    @Generated
    private ResidualSeasonalityTests getResidualsTests() {
        return this.residualsTests;
    }

    @Generated
    private ResidualSeasonalityTests getLsaTests() {
        return this.lsaTests;
    }

    @Generated
    private ResidualSeasonalityTests getLirrTests() {
        return this.lirrTests;
    }

    @Generated
    private CombinedSeasonalityTests getCombinedTests() {
        return this.combinedTests;
    }

    @Generated
    private ResidualTradingDaysTests getTdTests() {
        return this.tdTests;
    }

    @Generated
    private OneStepAheadForecastingTest getOutOfSampleTest() {
        return this.outOfSampleTest;
    }

    @Generated
    public static class Builder {
        @Generated
        private RegSarimaModel regarima;
        @Generated
        private boolean mul;
        @Generated
        private TsData y;
        @Generated
        private TsData res;
        @Generated
        private TsData sa;
        @Generated
        private TsData irr;
        @Generated
        private TsData si;
        @Generated
        private TsData lin;
        @Generated
        private TsData lsa;
        @Generated
        private TsData lirr;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder regarima(RegSarimaModel regarima) {
            this.regarima = regarima;
            return this;
        }

        @Generated
        public @NonNull Builder mul(boolean mul) {
            this.mul = mul;
            return this;
        }

        @Generated
        public @NonNull Builder y(TsData y) {
            this.y = y;
            return this;
        }

        @Generated
        public @NonNull Builder res(TsData res) {
            this.res = res;
            return this;
        }

        @Generated
        public @NonNull Builder sa(TsData sa) {
            this.sa = sa;
            return this;
        }

        @Generated
        public @NonNull Builder irr(TsData irr) {
            this.irr = irr;
            return this;
        }

        @Generated
        public @NonNull Builder si(TsData si) {
            this.si = si;
            return this;
        }

        @Generated
        public @NonNull Builder lin(TsData lin) {
            this.lin = lin;
            return this;
        }

        @Generated
        public @NonNull Builder lsa(TsData lsa) {
            this.lsa = lsa;
            return this;
        }

        @Generated
        public @NonNull Builder lirr(TsData lirr) {
            this.lirr = lirr;
            return this;
        }

        @Generated
        public @NonNull GenericSaTests build() {
            return new GenericSaTests(this.regarima, this.mul, this.y, this.res, this.sa, this.irr, this.si, this.lin, this.lsa, this.lirr);
        }

        @Generated
        public @NonNull String toString() {
            return "GenericSaTests.Builder(regarima=" + String.valueOf(this.regarima) + ", mul=" + this.mul + ", y=" + String.valueOf(this.y) + ", res=" + String.valueOf(this.res) + ", sa=" + String.valueOf(this.sa) + ", irr=" + String.valueOf(this.irr) + ", si=" + String.valueOf(this.si) + ", lin=" + String.valueOf(this.lin) + ", lsa=" + String.valueOf(this.lsa) + ", lirr=" + String.valueOf(this.lirr) + ")";
        }
    }
}

