/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.util.Collections2;
import jdplus.toolkit.base.api.util.function.BiIntPredicate;
import lombok.Generated;
import lombok.NonNull;

public final class TsDataTable {
    @NonNull
    private final TsDomain domain;
    @NonNull
    private final List<TsData> data;

    @NonNull
    public static <X> TsDataTable of(@NonNull Iterable<X> col, @NonNull Function<? super X, TsData> toData) {
        if (col == null) {
            throw new NullPointerException("col is marked non-null but is null");
        }
        if (toData == null) {
            throw new NullPointerException("toData is marked non-null but is null");
        }
        TsDomain domain = TsDataTable.computeDomain(Collections2.streamOf(col).map(toData).filter(Objects::nonNull).map(TsData::getDomain).filter(o -> !o.isEmpty()).iterator());
        return new TsDataTable(domain, Collections2.streamOf(col).map(toData).toList());
    }

    @NonNull
    public static TsDataTable of(@NonNull Iterable<TsData> col) {
        if (col == null) {
            throw new NullPointerException("col is marked non-null but is null");
        }
        return TsDataTable.of(col, Function.identity());
    }

    @NonNull
    public Cursor cursor(@NonNull DistributionType distribution) {
        Objects.requireNonNull(distribution);
        return this.cursor((int i) -> distribution);
    }

    @NonNull
    public Cursor cursor(@NonNull IntFunction<DistributionType> distribution) {
        Objects.requireNonNull(distribution);
        return new Cursor(TsDataTable.getDistributors(this.data, distribution));
    }

    private static List<BiIntPredicate> getDistributors(List<TsData> data, IntFunction<DistributionType> distribution) {
        return IntStream.range(0, data.size()).mapToObj(distribution).map(TsDataTable::getDistributor).collect(Collectors.toList());
    }

    private static BiIntPredicate getDistributor(DistributionType type) {
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> (pos, size) -> pos % size == 0;
            case 1 -> (pos, size) -> pos % size == size - 1;
            case 2 -> (pos, size) -> pos % size == size / 2;
        };
    }

    static TsDomain computeDomain(Iterator<TsDomain> domains) {
        if (!domains.hasNext()) {
            return TsDomain.DEFAULT_EMPTY;
        }
        TsDomain o = domains.next();
        TsUnit lowestUnit = o.getTsUnit();
        LocalDateTime minDate = o.start();
        LocalDateTime maxDate = o.end();
        LocalDateTime epoch = o.getStartPeriod().getEpoch();
        while (domains.hasNext()) {
            LocalDateTime cepoch;
            o = domains.next();
            lowestUnit = TsUnit.gcd(lowestUnit, o.getTsUnit());
            if (minDate.isAfter(o.start())) {
                minDate = o.start();
            }
            if (maxDate.isBefore(o.end())) {
                maxDate = o.end();
            }
            if ((cepoch = o.getStartPeriod().getEpoch()).equals(epoch)) continue;
            epoch = TsPeriod.DEFAULT_EPOCH;
        }
        TsPeriod startPeriod = TsPeriod.make(epoch, lowestUnit, minDate);
        TsPeriod endPeriod = TsPeriod.make(epoch, lowestUnit, maxDate);
        return TsDomain.of(startPeriod, startPeriod.until(endPeriod));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Cursor cursor = this.cursor(DistributionType.LAST);
        int pos = 0;
        for (TsPeriod period : this.domain) {
            builder.append(period.getStartAsShortString());
            for (int i = 0; i < this.data.size(); ++i) {
                cursor.moveTo(pos, i);
                builder.append('\t');
                if (cursor.getStatus() != ValueStatus.PRESENT) continue;
                builder.append(cursor.getValue());
            }
            ++pos;
            builder.append("\r\n");
        }
        return builder.toString();
    }

    public Matrix toMatrix() {
        return this.toMatrix(DistributionType.LAST);
    }

    public Matrix toMatrix(DistributionType type) {
        int nr = this.domain.length();
        int nc = this.data.size();
        Cursor cursor = this.cursor(type);
        double[] m = new double[nr * nc];
        int row = 0;
        int j0 = 0;
        while (row < nr) {
            int col = 0;
            int j = j0;
            while (col < nc) {
                cursor.moveTo(row, col);
                m[j] = cursor.getStatus() == ValueStatus.PRESENT ? cursor.getValue() : Double.NaN;
                ++col;
                j += nr;
            }
            ++row;
            ++j0;
        }
        return Matrix.of(m, nr, nc);
    }

    @NonNull
    @Generated
    public TsDomain getDomain() {
        return this.domain;
    }

    @NonNull
    @Generated
    public List<TsData> getData() {
        return this.data;
    }

    @Generated
    private TsDataTable(@NonNull TsDomain domain, @NonNull List<TsData> data) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.domain = domain;
        this.data = data;
    }

    public static enum DistributionType {
        FIRST,
        LAST,
        MIDDLE;

    }

    public final class Cursor {
        private final List<BiIntPredicate> distributors;
        private int index = -1;
        private int windowLength = -1;
        private int windowIndex = -1;
        @NonNull
        private ValueStatus status = ValueStatus.EMPTY;
        private double value = Double.NaN;

        @NonNull
        public Cursor moveTo(int period, int series) {
            if (period <= -1 || period >= TsDataTable.this.domain.getLength()) {
                throw new IndexOutOfBoundsException("period");
            }
            TsData ts = TsDataTable.this.data.get(series);
            if (ts.isEmpty()) {
                this.index = -1;
                this.windowLength = -1;
                this.windowIndex = -1;
                this.status = ValueStatus.EMPTY;
                this.value = Double.NaN;
            } else {
                TsPeriod current = TsDataTable.this.domain.getStartPeriod().plus(period);
                TsPeriod valuePeriod = current.withUnit(ts.getDomain().getTsUnit());
                this.index = ts.getDomain().position(valuePeriod);
                if (this.isInBounds(ts, this.index)) {
                    TsPeriod start = valuePeriod.withUnit(current.getUnit());
                    TsPeriod end = valuePeriod.next().withUnit(current.getUnit());
                    this.windowLength = start.until(end);
                    this.windowIndex = start.until(current);
                    if (this.distributors.get(series).test(this.windowIndex, this.windowLength)) {
                        this.status = ValueStatus.PRESENT;
                        this.value = ts.getValue(this.index);
                    } else {
                        this.status = ValueStatus.UNUSED;
                        this.value = Double.NaN;
                    }
                } else {
                    this.windowLength = -1;
                    this.windowIndex = -1;
                    this.status = this.index < 0 ? ValueStatus.BEFORE : ValueStatus.AFTER;
                    this.value = Double.NaN;
                }
            }
            return this;
        }

        private boolean isInBounds(TsData ts, int index) {
            return index >= 0 && index < ts.length();
        }

        public int getPeriodCount() {
            return TsDataTable.this.domain.getLength();
        }

        public int getSeriesCount() {
            return TsDataTable.this.data.size();
        }

        @Generated
        private Cursor(List<BiIntPredicate> distributors) {
            this.distributors = distributors;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public int getWindowLength() {
            return this.windowLength;
        }

        @Generated
        public int getWindowIndex() {
            return this.windowIndex;
        }

        @NonNull
        @Generated
        public ValueStatus getStatus() {
            return this.status;
        }

        @Generated
        public double getValue() {
            return this.value;
        }
    }

    public static enum ValueStatus {
        PRESENT,
        UNUSED,
        BEFORE,
        AFTER,
        EMPTY;

    }
}

