/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.CalendarPeriod;
import jdplus.toolkit.base.api.timeseries.TimeSeriesObs;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class CalendarPeriodObs
implements TimeSeriesObs<CalendarPeriod>,
HasShortStringRepresentation {
    @NonNull
    private final LocalDate start;
    @NonNull
    private final LocalDate end;
    private final double value;

    @NonNull
    public static CalendarPeriodObs of(@NonNull CalendarPeriod period, double value) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        return new CalendarPeriodObs(period.getStart(), period.getEnd(), value);
    }

    @NonNull
    public static CalendarPeriodObs parse(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        int index = text.toString().indexOf("=");
        if (index < 0) {
            throw new IllegalArgumentException("Invalid CalendarPeriodObs text: " + String.valueOf(text));
        }
        return CalendarPeriodObs.of(CalendarPeriod.parse(text.subSequence(0, index)), Double.parseDouble(text.subSequence(index + 1, text.length()).toString()));
    }

    @Override
    @NonNull
    public CalendarPeriod getPeriod() {
        return CalendarPeriod.of(this.start, this.end);
    }

    public String toString() {
        return String.valueOf(this.getPeriod()) + "=" + this.value;
    }

    @Override
    @NonNull
    public String toShortString() {
        return this.getPeriod().toShortString() + "=" + this.value;
    }

    @Generated
    private CalendarPeriodObs(@NonNull LocalDate start, @NonNull LocalDate end, double value) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.start = start;
        this.end = end;
        this.value = value;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull CalendarPeriodObs of(@NonNull LocalDate start, @NonNull LocalDate end, double value) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return new CalendarPeriodObs(start, end, value);
    }

    @NonNull
    @Generated
    public LocalDate getStart() {
        return this.start;
    }

    @NonNull
    @Generated
    public LocalDate getEnd() {
        return this.end;
    }

    @Override
    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarPeriodObs)) {
            return false;
        }
        CalendarPeriodObs other = (CalendarPeriodObs)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        LocalDate this$start = this.getStart();
        LocalDate other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDate this$end = this.getEnd();
        LocalDate other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        LocalDate $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDate $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }
}

