/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDocument;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import lombok.NonNull;

public abstract class AbstractTsDocument<S extends ProcSpecification, R extends Explorable>
implements TsDocument<S, R> {
    private final UUID uuid;
    private Map<String, String> metadata = Collections.emptyMap();
    @NonNull
    private S specification;
    private boolean locked = false;
    private Ts input;
    private R result;
    private volatile ProcessingStatus status = ProcessingStatus.Unprocessed;

    protected AbstractTsDocument(S spec) {
        this.specification = spec;
        this.uuid = UUID.randomUUID();
    }

    private void clear() {
        this.result = null;
        this.status = ProcessingStatus.Unprocessed;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public Ts getInput() {
        return this.input;
    }

    @Override
    public S getSpecification() {
        return this.specification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(S newSpec, Ts newInput) {
        if (this.locked) {
            return;
        }
        AbstractTsDocument abstractTsDocument = this;
        synchronized (abstractTsDocument) {
            this.specification = newSpec;
            this.input = newInput;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(S newSpec) {
        AbstractTsDocument abstractTsDocument = this;
        synchronized (abstractTsDocument) {
            this.specification = newSpec;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Ts newInput) {
        if (this.locked) {
            return;
        }
        AbstractTsDocument abstractTsDocument = this;
        synchronized (abstractTsDocument) {
            this.input = newInput;
            this.clear();
        }
    }

    @Override
    public void setMetadata(Map<String, String> newMetadata) {
        this.metadata = Collections.unmodifiableMap(newMetadata);
    }

    @Override
    public void updateMetadata(Map<String, String> update) {
        HashMap<String, String> md = new HashMap<String, String>(this.metadata);
        md.putAll(update);
        this.metadata = Collections.unmodifiableMap(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingStatus process() {
        ProcessingStatus cur = this.status;
        if (cur == ProcessingStatus.Unprocessed) {
            AbstractTsDocument abstractTsDocument = this;
            synchronized (abstractTsDocument) {
                if (this.status == ProcessingStatus.Unprocessed) {
                    this.rawProcess();
                }
                cur = this.status;
            }
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshTs(TsFactory factory, TsInformationType type) {
        AbstractTsDocument abstractTsDocument = this;
        synchronized (abstractTsDocument) {
            if (this.input == null) {
                return;
            }
            boolean frozen = this.input.isFrozen();
            Ts ninput = frozen ? this.input.unfreeze(factory, type).freeze() : this.input.load(type, factory);
            boolean del = this.input != ninput;
            this.input = ninput;
            if (del) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze() {
        AbstractTsDocument abstractTsDocument = this;
        synchronized (abstractTsDocument) {
            if (this.input == null || this.input.isFrozen()) {
                return;
            }
            this.input = this.input.freeze();
        }
    }

    private boolean check() {
        if (this.input == null) {
            return false;
        }
        if (this.input.getData().isEmpty()) {
            Ts s = TsFactory.getDefault().makeTs(this.input.getMoniker(), TsInformationType.Data);
            if (s.getData().isEmpty()) {
                throw new IllegalArgumentException("No data");
            }
            this.input = s;
        }
        return true;
    }

    private void rawProcess() {
        if (this.check()) {
            try {
                this.result = this.internalProcess(this.specification, this.input.getData());
                this.status = this.result.isValid() ? ProcessingStatus.Valid : ProcessingStatus.Invalid;
            }
            catch (Exception err) {
                HashMap<String, String> md = new HashMap<String, String>(this.metadata);
                md.put("@error", err.getLocalizedMessage());
                this.result = null;
                this.status = ProcessingStatus.Invalid;
            }
        } else {
            this.result = null;
            this.status = ProcessingStatus.Unprocessed;
        }
    }

    protected abstract R internalProcess(S var1, TsData var2);

    @Override
    public UUID getKey() {
        return this.uuid;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R getResult() {
        ProcessingStatus cur = this.status;
        if (cur == ProcessingStatus.Unprocessed) {
            AbstractTsDocument abstractTsDocument = this;
            synchronized (abstractTsDocument) {
                if (this.status == ProcessingStatus.Unprocessed) {
                    this.rawProcess();
                }
            }
        }
        return this.result;
    }

    @Override
    public ProcessingStatus getStatus() {
        return this.status;
    }

    @Override
    public void setAll(S spec, Ts input, R result) {
        this.input = input;
        this.specification = spec;
        this.result = result;
        this.status = result != null ? ProcessingStatus.Valid : ProcessingStatus.Invalid;
    }
}

