/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;

public final class TsDataView {
    private final DoubleSeq data;
    private final int inc;
    private final TsPeriod start;

    public static TsDataView fullYears(TsData series) {
        TsDomain domain = series.getDomain();
        TsPeriod start = domain.getStartPeriod();
        TsPeriod end = domain.getEndPeriod();
        if (start.getEpoch() != TsPeriod.DEFAULT_EPOCH) {
            throw new TsException("Invalid operation");
        }
        int period = domain.getAnnualFrequency();
        if (period < 0) {
            throw new TsException("Invalid operation");
        }
        TsPeriod nstart = start.withUnit(TsUnit.P1Y);
        int nbeg = TsDomain.splitOf((TsPeriod)nstart, (TsUnit)start.getUnit(), (boolean)true).indexOf(start);
        if (nbeg != 0) {
            nbeg = period - nbeg;
        }
        int nend = TsDomain.splitOf((TsPeriod)end.withUnit(TsUnit.P1Y), (TsUnit)end.getUnit(), (boolean)true).indexOf(end);
        int len = series.length() - nend - nbeg;
        int beg = nbeg;
        return new TsDataView(start.plus((long)nbeg), DoubleSeq.onMapping((int)len, i -> series.getValue(beg + i)), 1);
    }

    public static TsDataView select(TsData series, TsDomain domain) {
        if (!series.getDomain().contains(domain)) {
            return null;
        }
        TsPeriod start = series.getStart();
        TsPeriod dstart = domain.getStartPeriod();
        int del = start.until(dstart);
        return new TsDataView(dstart, DoubleSeq.onMapping((int)domain.length(), i -> series.getValue(del + i)), 1);
    }

    public static TsDataView select(TsData series, TimeSelector selector) {
        TsDomain domain = series.getDomain().select(selector);
        if (domain == null || domain.isEmpty()) {
            return null;
        }
        TsPeriod start = series.getStart();
        TsPeriod dstart = domain.getStartPeriod();
        int del = start.until(dstart);
        return new TsDataView(dstart, DoubleSeq.onMapping((int)domain.length(), i -> series.getValue(del + i)), 1);
    }

    public static TsDataView all(TsData series) {
        return new TsDataView(series.getStart(), series.getValues(), 1);
    }

    public TsPeriod period(int i) {
        return this.start.plus((long)(this.inc * i));
    }

    TsDataView(TsPeriod start, DoubleSeq data, int inc) {
        this.start = start;
        this.data = data;
        this.inc = inc;
    }

    public DoubleSeq getData() {
        return this.data;
    }

    public TsPeriod getStart() {
        return this.start;
    }
}

