/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.Easter;
import jdplus.toolkit.base.api.timeseries.calendars.EasterRelatedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedWeekDay;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.calendars.PrespecifiedHoliday;
import jdplus.toolkit.base.api.timeseries.calendars.SingleDate;
import jdplus.toolkit.base.core.timeseries.calendars.EasterDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.FixedDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.FixedWeekDayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import jdplus.toolkit.base.core.timeseries.calendars.SingleDateInfo;

interface HolidayImpl {
    public Iterable<HolidayInfo> getIterable(int var1, LocalDate var2, LocalDate var3);

    public double[][] getLongTermMeanEffect(int var1);

    public TsDomain getDomainForLongTermCorrection(int var1, LocalDate var2, LocalDate var3);

    public static HolidayImpl implementationOf(Holiday holiday) {
        if (holiday instanceof FixedDay) {
            FixedDay fd = (FixedDay)holiday;
            return new FixedDayImpl(fd);
        }
        if (holiday instanceof EasterRelatedDay) {
            EasterRelatedDay sd = (EasterRelatedDay)holiday;
            return new EasterDayImpl(sd);
        }
        if (holiday instanceof SingleDate) {
            SingleDate sd = (SingleDate)holiday;
            return new SingleDateImpl(sd);
        }
        if (holiday instanceof FixedWeekDay) {
            FixedWeekDay fd = (FixedWeekDay)holiday;
            return new FixedWeekDayImpl(fd);
        }
        if (holiday instanceof PrespecifiedHoliday) {
            PrespecifiedHoliday ph = (PrespecifiedHoliday)holiday;
            return HolidayImpl.implementationOf(ph.rawHoliday().forPeriod(ph.start(), ph.end()));
        }
        return null;
    }

    public static class FixedDayImpl
    implements HolidayImpl {
        final FixedDay definition;

        FixedDayImpl(FixedDay definition) {
            this.definition = definition;
        }

        @Override
        public Iterable<HolidayInfo> getIterable(int freq, LocalDate start, LocalDate end) {
            return new FixedDayInfo.FixedDayIterable(this.definition, start, end);
        }

        @Override
        public double[][] getLongTermMeanEffect(int freq) {
            int c = 12 / freq;
            int p = (this.definition.getMonth() - 1) / c;
            double[] m = new double[7];
            for (int i = 0; i < 7; ++i) {
                m[i] = this.definition.getWeight() / 7.0;
            }
            double[][] rslt = new double[freq][];
            rslt[p] = m;
            return rslt;
        }

        @Override
        public TsDomain getDomainForLongTermCorrection(int freq, LocalDate start, LocalDate end) {
            LocalDate vstart = this.definition.start();
            LocalDate vend = this.definition.end();
            if (vstart.isAfter(start)) {
                start = vstart;
            }
            if (vend.isBefore(end)) {
                end = vend;
            }
            TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)start);
            TsPeriod pend = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)end);
            int n = pstart.until(pend);
            return TsDomain.of((TsPeriod)pstart, (int)Math.max(0, n));
        }
    }

    public static class EasterDayImpl
    implements HolidayImpl {
        private static final int START = 80;
        private static final int JSTART = 90;
        private static final int DEL = 35;
        private static final int JDEL = 43;
        private static final int[] MDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        final EasterRelatedDay definition;

        EasterDayImpl(EasterRelatedDay definition) {
            this.definition = definition;
        }

        @Override
        public Iterable<HolidayInfo> getIterable(int freq, LocalDate start, LocalDate end) {
            return new EasterDayInfo.EasterDayList(this.definition.getOffset(), this.definition.isJulian(), start, end);
        }

        @Override
        public double[][] getLongTermMeanEffect(int freq) {
            int d1;
            int d0;
            int w = this.definition.getOffset() % 7;
            if (w == 0) {
                w = 7;
            }
            if (w < 0) {
                w += 7;
            }
            --w;
            if (this.definition.isJulian()) {
                d0 = 90 + this.definition.getOffset();
                d1 = d0 + 43;
            } else {
                d0 = 80 + this.definition.getOffset();
                d1 = d0 + 35;
            }
            int ifreq = freq;
            int c = 12 / ifreq;
            int c0 = 0;
            int c1 = 0;
            for (int i = 0; i < c; ++i) {
                c1 += MDAYS[i];
            }
            double[][] rslt = new double[ifreq][];
            int i = 0;
            while (i < ifreq) {
                if (d0 < c1 && d1 > c0) {
                    double[] m = new double[7];
                    double x = 0.0;
                    for (int j = Math.max(d0, c0); j < Math.min(d1, c1); ++j) {
                        x += this.probEaster(j - d0);
                    }
                    m[w] = x * this.definition.getWeight();
                    rslt[i] = m;
                }
                c0 = c1;
                if (++i >= ifreq) continue;
                for (int j = 0; j < c; ++j) {
                    c1 += MDAYS[i * c + j];
                }
            }
            return rslt;
        }

        @Override
        public TsDomain getDomainForLongTermCorrection(int freq, LocalDate start, LocalDate end) {
            LocalDate vstart = this.definition.start();
            LocalDate vend = this.definition.end();
            if (vstart.isAfter(start)) {
                start = vstart;
            }
            if (vend.isBefore(end)) {
                end = vend;
            }
            TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)start);
            TsPeriod pend = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)end);
            int n = pstart.until(pend);
            return TsDomain.of((TsPeriod)pstart, (int)Math.max(0, n));
        }

        private double probEaster(int del) {
            return this.definition.isJulian() ? Easter.probJulianEaster((int)del) : Easter.probEaster((int)del);
        }
    }

    public static class SingleDateImpl
    implements HolidayImpl {
        final SingleDate definition;

        SingleDateImpl(SingleDate definition) {
            this.definition = definition;
        }

        @Override
        public Iterable<HolidayInfo> getIterable(int freq, LocalDate start, LocalDate end) {
            return new SingleDateInfo.SingleDateIterable(this.definition, start, end);
        }

        @Override
        public double[][] getLongTermMeanEffect(int freq) {
            return null;
        }

        @Override
        public TsDomain getDomainForLongTermCorrection(int freq, LocalDate start, LocalDate end) {
            TsUnit unit = TsUnit.ofAnnualFrequency((int)freq);
            TsPeriod pstart = TsPeriod.of((TsUnit)unit, (LocalDate)this.definition.getDate());
            return TsDomain.of((TsPeriod)pstart, (int)0);
        }
    }

    public static class FixedWeekDayImpl
    implements HolidayImpl {
        final FixedWeekDay definition;

        FixedWeekDayImpl(FixedWeekDay definition) {
            this.definition = definition;
        }

        @Override
        public Iterable<HolidayInfo> getIterable(int freq, LocalDate start, LocalDate end) {
            return new FixedWeekDayInfo.FixedWeekDayIterable(this.definition, start, end);
        }

        @Override
        public double[][] getLongTermMeanEffect(int freq) {
            int c = 12 / freq;
            int p = (this.definition.getMonth() - 1) / c;
            double[] m = new double[7];
            for (int i = 0; i < 7; ++i) {
                m[i] = this.definition.getWeight() / 7.0;
            }
            double[][] rslt = new double[freq][];
            rslt[p] = m;
            return rslt;
        }

        @Override
        public TsDomain getDomainForLongTermCorrection(int freq, LocalDate start, LocalDate end) {
            LocalDate vstart = this.definition.start();
            LocalDate vend = this.definition.end();
            if (vstart.isAfter(start)) {
                start = vstart;
            }
            if (vend.isBefore(end)) {
                end = vend;
            }
            TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)start);
            TsPeriod pend = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)end);
            int n = pstart.until(pend);
            return TsDomain.of((TsPeriod)pstart, (int)Math.max(0, n));
        }
    }
}

